/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.context;

import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.context.CarrotDashboardLogger;
import cn.boboweike.carrot.tasks.context.TaskDashboardLogger;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.gson.GsonJsonMapper;
import cn.boboweike.carrot.utils.mapper.jackson.JacksonJsonMapper;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@ExtendWith(value={MockitoExtension.class})
public class CarrotDashboardLoggerTest {
    @Mock
    private Logger slfLogger;
    private CarrotDashboardLogger CarrotDashboardLogger;
    private final Marker marker = MarkerFactory.getMarker((String)"some marker");

    @BeforeEach
    void setUpTaskLogger() {
        this.CarrotDashboardLogger = new CarrotDashboardLogger(this.slfLogger);
    }

    @AfterEach
    void cleanUp() {
        CarrotDashboardLoggerTest carrotDashboardLoggerTest = this;
        carrotDashboardLoggerTest.CarrotDashboardLogger.clearTask();
    }

    @Test
    void testInfoLoggingWithoutTask() {
        this.CarrotDashboardLogger.info("simple message");
        ((Logger)Mockito.verify((Object)this.slfLogger)).info("simple message");
    }

    @Test
    void testInfoLoggingWithTask() {
        Task Task2 = TaskTestBuilder.aTaskInProgress().build();
        cn.boboweike.carrot.tasks.context.CarrotDashboardLogger.setTask((Task)Task2);
        this.CarrotDashboardLogger.info("simple message");
        ((Logger)Mockito.verify((Object)this.slfLogger)).info("simple message");
        CarrotAssertions.assertThat(Task2).hasMetadata(InfoLog.withMessage("simple message"));
    }

    @Test
    void testInfoLoggingWithTaskAndFormattingOneArgument() {
        Task Task2 = TaskTestBuilder.aTaskInProgress().build();
        cn.boboweike.carrot.tasks.context.CarrotDashboardLogger.setTask((Task)Task2);
        this.CarrotDashboardLogger.info("simple message {}", (Object)"hello");
        ((Logger)Mockito.verify((Object)this.slfLogger)).info("simple message {}", (Object)"hello");
        CarrotAssertions.assertThat(Task2).hasMetadata(InfoLog.withMessage("simple message hello"));
    }

    @Test
    void testInfoLoggingWithTaskAndFormattingMultipleArguments() {
        Task Task2 = TaskTestBuilder.aTaskInProgress().build();
        cn.boboweike.carrot.tasks.context.CarrotDashboardLogger.setTask((Task)Task2);
        this.CarrotDashboardLogger.info("simple message {} {} {}", new Object[]{"hello", "again", "there"});
        ((Logger)Mockito.verify((Object)this.slfLogger)).info("simple message {} {} {}", new Object[]{"hello", "again", "there"});
        CarrotAssertions.assertThat(Task2).hasMetadata(InfoLog.withMessage("simple message hello again there"));
    }

    @Test
    void testWarnLoggingWithoutTask() {
        this.CarrotDashboardLogger.warn("simple message");
        ((Logger)Mockito.verify((Object)this.slfLogger)).warn("simple message");
    }

    @Test
    void testWarnLoggingWithTask() {
        Task Task2 = TaskTestBuilder.aTaskInProgress().build();
        cn.boboweike.carrot.tasks.context.CarrotDashboardLogger.setTask((Task)Task2);
        this.CarrotDashboardLogger.warn("simple message");
        ((Logger)Mockito.verify((Object)this.slfLogger)).warn("simple message");
        CarrotAssertions.assertThat(Task2).hasMetadata(WarnLog.withMessage("simple message"));
    }

    @Test
    void testWarnLoggingWithTaskAndFormattingOneArgument() {
        Task Task2 = TaskTestBuilder.aTaskInProgress().build();
        cn.boboweike.carrot.tasks.context.CarrotDashboardLogger.setTask((Task)Task2);
        this.CarrotDashboardLogger.warn("simple message {}", (Object)"hello");
        ((Logger)Mockito.verify((Object)this.slfLogger)).warn("simple message {}", (Object)"hello");
        CarrotAssertions.assertThat(Task2).hasMetadata(WarnLog.withMessage("simple message hello"));
    }

    @Test
    void testWarnLoggingWithTaskAndFormattingMultipleArguments() {
        Task Task2 = TaskTestBuilder.aTaskInProgress().build();
        cn.boboweike.carrot.tasks.context.CarrotDashboardLogger.setTask((Task)Task2);
        this.CarrotDashboardLogger.warn("simple message {} {} {}", new Object[]{"hello", "again", "there"});
        ((Logger)Mockito.verify((Object)this.slfLogger)).warn("simple message {} {} {}", new Object[]{"hello", "again", "there"});
        CarrotAssertions.assertThat(Task2).hasMetadata(WarnLog.withMessage("simple message hello again there"));
    }

    @Test
    void testErrorLoggingWithoutTask() {
        this.CarrotDashboardLogger.error("simple message");
        ((Logger)Mockito.verify((Object)this.slfLogger)).error("simple message");
    }

    @Test
    void testErrorLoggingWithTask() {
        Task Task2 = TaskTestBuilder.aTaskInProgress().build();
        cn.boboweike.carrot.tasks.context.CarrotDashboardLogger.setTask((Task)Task2);
        this.CarrotDashboardLogger.error("simple message");
        ((Logger)Mockito.verify((Object)this.slfLogger)).error("simple message");
        CarrotAssertions.assertThat(Task2).hasMetadata(ErrorLog.withMessage("simple message"));
    }

    @Test
    void testErrorLoggingWithTaskAndFormattingOneArgument() {
        Task Task2 = TaskTestBuilder.aTaskInProgress().build();
        cn.boboweike.carrot.tasks.context.CarrotDashboardLogger.setTask((Task)Task2);
        this.CarrotDashboardLogger.error("simple message {}", (Object)"hello");
        ((Logger)Mockito.verify((Object)this.slfLogger)).error("simple message {}", (Object)"hello");
        CarrotAssertions.assertThat(Task2).hasMetadata(ErrorLog.withMessage("simple message hello"));
    }

    @Test
    void testErrorLoggingWithTaskAndFormattingMultipleArguments() {
        Task Task2 = TaskTestBuilder.aTaskInProgress().build();
        cn.boboweike.carrot.tasks.context.CarrotDashboardLogger.setTask((Task)Task2);
        this.CarrotDashboardLogger.error("simple message {} {} {}", new Object[]{"hello", "again", "there"});
        ((Logger)Mockito.verify((Object)this.slfLogger)).error("simple message {} {} {}", new Object[]{"hello", "again", "there"});
        CarrotAssertions.assertThat(Task2).hasMetadata(ErrorLog.withMessage("simple message hello again there"));
    }

    @Test
    void testInfoLoggingWithTaskAndThreshold() {
        this.CarrotDashboardLogger = new CarrotDashboardLogger(this.slfLogger, TaskDashboardLogger.Level.WARN);
        Task Task2 = TaskTestBuilder.aTaskInProgress().build();
        cn.boboweike.carrot.tasks.context.CarrotDashboardLogger.setTask((Task)Task2);
        this.CarrotDashboardLogger.info("simple message");
        ((Logger)Mockito.verify((Object)this.slfLogger)).info("simple message");
        CarrotAssertions.assertThat(Task2).hasMetadata((Condition)Assertions.not((Condition)InfoLog.withMessage("simple message")));
    }

    @Test
    void testWarnLoggingWithTaskAndThreshold() {
        this.CarrotDashboardLogger = new CarrotDashboardLogger(this.slfLogger, TaskDashboardLogger.Level.ERROR);
        Task Task2 = TaskTestBuilder.aTaskInProgress().build();
        cn.boboweike.carrot.tasks.context.CarrotDashboardLogger.setTask((Task)Task2);
        this.CarrotDashboardLogger.warn("simple message");
        ((Logger)Mockito.verify((Object)this.slfLogger)).warn("simple message");
        CarrotAssertions.assertThat(Task2).hasMetadata((Condition)Assertions.not((Condition)WarnLog.withMessage("simple message")));
    }

    @Test
    void CarrotDashboardLoggerIsThreadSafe1() throws InterruptedException {
        this.CarrotDashboardLogger = new CarrotDashboardLogger(this.slfLogger);
        Task Task1 = TaskTestBuilder.aTaskInProgress().withName("Task1").build();
        Task Task2 = TaskTestBuilder.aTaskInProgress().withName("Task2").build();
        CountDownLatch countDownLatch = new CountDownLatch(2);
        Thread thread1 = new Thread(this.loggingRunnable(Task1, this.CarrotDashboardLogger, countDownLatch));
        Thread thread2 = new Thread(this.loggingRunnable(Task2, this.CarrotDashboardLogger, countDownLatch));
        thread1.start();
        thread2.start();
        countDownLatch.await(5L, TimeUnit.SECONDS);
        CarrotAssertions.assertThat(Task1).hasMetadata(InfoLog.withMessage("info from Task1")).hasMetadata((Condition)Assertions.not((Condition)InfoLog.withMessage("info from Task2")));
        CarrotAssertions.assertThat(Task2).hasMetadata((Condition)Assertions.not((Condition)InfoLog.withMessage("info from Task1"))).hasMetadata(InfoLog.withMessage("info from Task2"));
    }

    @Test
    void testName() {
        Mockito.when((Object)this.slfLogger.getName()).thenReturn((Object)"the name");
        CarrotAssertions.assertThat((String)this.CarrotDashboardLogger.getName()).isEqualTo("the name");
    }

    @Test
    void testIsTraceEnabled() {
        this.CarrotDashboardLogger.isTraceEnabled();
        ((Logger)Mockito.verify((Object)this.slfLogger)).isTraceEnabled();
    }

    @Test
    void testTrace() {
        this.CarrotDashboardLogger.trace("trace");
        ((Logger)Mockito.verify((Object)this.slfLogger)).trace("trace");
    }

    @Test
    void testTraceWithFormat() {
        this.CarrotDashboardLogger.trace("trace with {}", (Object)"format");
        ((Logger)Mockito.verify((Object)this.slfLogger)).trace("trace with {}", (Object)"format");
    }

    @Test
    void testTraceWithFormat2() {
        this.CarrotDashboardLogger.trace("trace with {} {}", (Object)"format1", (Object)"format2");
        ((Logger)Mockito.verify((Object)this.slfLogger)).trace("trace with {} {}", (Object)"format1", (Object)"format2");
    }

    @Test
    void testTraceWithFormat3() {
        this.CarrotDashboardLogger.trace("trace with {} {} {}", new Object[]{"format1", "format2", "format3"});
        ((Logger)Mockito.verify((Object)this.slfLogger)).trace("trace with {} {} {}", new Object[]{"format1", "format2", "format3"});
    }

    @Test
    void testTraceWithException() {
        Exception exception = new Exception();
        this.CarrotDashboardLogger.trace("trace", (Throwable)exception);
        ((Logger)Mockito.verify((Object)this.slfLogger)).trace("trace", (Throwable)exception);
    }

    @Test
    void testMarkerTrace() {
        this.CarrotDashboardLogger.trace(this.marker, "trace");
        ((Logger)Mockito.verify((Object)this.slfLogger)).trace(this.marker, "trace");
    }

    @Test
    void testMarkerTraceWithFormat() {
        this.CarrotDashboardLogger.trace(this.marker, "trace with {}", (Object)"format");
        ((Logger)Mockito.verify((Object)this.slfLogger)).trace(this.marker, "trace with {}", (Object)"format");
    }

    @Test
    void testMarkerTraceWithFormat2() {
        this.CarrotDashboardLogger.trace(this.marker, "trace with {} {}", (Object)"format1", (Object)"format2");
        ((Logger)Mockito.verify((Object)this.slfLogger)).trace(this.marker, "trace with {} {}", (Object)"format1", (Object)"format2");
    }

    @Test
    void testMarkerTraceWithFormat3() {
        this.CarrotDashboardLogger.trace(this.marker, "trace with {} {} {}", new Object[]{"format1", "format2", "format3"});
        ((Logger)Mockito.verify((Object)this.slfLogger)).trace(this.marker, "trace with {} {} {}", new Object[]{"format1", "format2", "format3"});
    }

    @Test
    void testMarkerTraceWithException() {
        Exception exception = new Exception();
        this.CarrotDashboardLogger.trace(this.marker, "trace", (Throwable)exception);
        ((Logger)Mockito.verify((Object)this.slfLogger)).trace(this.marker, "trace", (Throwable)exception);
    }

    @Test
    void testIsDebugEnabled() {
        this.CarrotDashboardLogger.isDebugEnabled();
        ((Logger)Mockito.verify((Object)this.slfLogger)).isDebugEnabled();
    }

    @Test
    void testDebug() {
        this.CarrotDashboardLogger.debug("Debug");
        ((Logger)Mockito.verify((Object)this.slfLogger)).debug("Debug");
    }

    @Test
    void testDebugWithFormat() {
        this.CarrotDashboardLogger.debug("Debug with {}", (Object)"format");
        ((Logger)Mockito.verify((Object)this.slfLogger)).debug("Debug with {}", (Object)"format");
    }

    @Test
    void testDebugWithFormat2() {
        this.CarrotDashboardLogger.debug("Debug with {} {}", (Object)"format1", (Object)"format2");
        ((Logger)Mockito.verify((Object)this.slfLogger)).debug("Debug with {} {}", (Object)"format1", (Object)"format2");
    }

    @Test
    void testDebugWithFormat3() {
        this.CarrotDashboardLogger.debug("Debug with {} {} {}", new Object[]{"format1", "format2", "format3"});
        ((Logger)Mockito.verify((Object)this.slfLogger)).debug("Debug with {} {} {}", new Object[]{"format1", "format2", "format3"});
    }

    @Test
    void testDebugWithException() {
        Exception exception = new Exception();
        this.CarrotDashboardLogger.debug("Debug", (Throwable)exception);
        ((Logger)Mockito.verify((Object)this.slfLogger)).debug("Debug", (Throwable)exception);
    }

    @Test
    void testMarkerDebug() {
        this.CarrotDashboardLogger.debug(this.marker, "Debug");
        ((Logger)Mockito.verify((Object)this.slfLogger)).debug(this.marker, "Debug");
    }

    @Test
    void testMarkerDebugWithFormat() {
        this.CarrotDashboardLogger.debug(this.marker, "Debug with {}", (Object)"format");
        ((Logger)Mockito.verify((Object)this.slfLogger)).debug(this.marker, "Debug with {}", (Object)"format");
    }

    @Test
    void testMarkerDebugWithFormat2() {
        this.CarrotDashboardLogger.debug(this.marker, "Debug with {} {}", (Object)"format1", (Object)"format2");
        ((Logger)Mockito.verify((Object)this.slfLogger)).debug(this.marker, "Debug with {} {}", (Object)"format1", (Object)"format2");
    }

    @Test
    void testMarkerDebugWithFormat3() {
        this.CarrotDashboardLogger.debug(this.marker, "Debug with {} {} {}", new Object[]{"format1", "format2", "format3"});
        ((Logger)Mockito.verify((Object)this.slfLogger)).debug(this.marker, "Debug with {} {} {}", new Object[]{"format1", "format2", "format3"});
    }

    @Test
    void testMarkerDebugWithException() {
        Exception exception = new Exception();
        this.CarrotDashboardLogger.debug(this.marker, "Debug", (Throwable)exception);
        ((Logger)Mockito.verify((Object)this.slfLogger)).debug(this.marker, "Debug", (Throwable)exception);
    }

    @Test
    void isInfoEnabled() {
        this.CarrotDashboardLogger.isInfoEnabled();
        ((Logger)Mockito.verify((Object)this.slfLogger)).isInfoEnabled();
    }

    @Test
    void isWarnEnabled() {
        this.CarrotDashboardLogger.isWarnEnabled();
        ((Logger)Mockito.verify((Object)this.slfLogger)).isWarnEnabled();
    }

    @Test
    void CarrotDashboardLoggerIsThreadSafeUsingJackson() throws InterruptedException {
        this.CarrotDashboardLoggerIsThreadSafeUsing(new TaskMapper((JsonMapper)new JacksonJsonMapper()));
    }

    @Test
    void CarrotDashboardLoggerIsThreadSafeUsingGson() throws InterruptedException {
        this.CarrotDashboardLoggerIsThreadSafeUsing(new TaskMapper((JsonMapper)new GsonJsonMapper()));
    }

    void CarrotDashboardLoggerIsThreadSafeUsing(TaskMapper TaskMapper2) throws InterruptedException {
        this.CarrotDashboardLogger = new CarrotDashboardLogger(this.slfLogger);
        Task Task2 = TaskTestBuilder.aTaskInProgress().withName("Task1").build();
        CountDownLatch countDownLatch = new CountDownLatch(2);
        Thread thread1 = new Thread(this.loggingRunnable(Task2, this.CarrotDashboardLogger, countDownLatch));
        Thread thread2 = new Thread(this.serializingRunnable(Task2, this.CarrotDashboardLogger, TaskMapper2, countDownLatch));
        thread1.start();
        thread2.start();
        countDownLatch.await(5L, TimeUnit.SECONDS);
        CarrotAssertions.assertThat(Task2).hasMetadata(InfoLog.withMessage("info from Task1")).hasMetadata(InfoLog.withMessage("successfully serialized Task Task1 100 times"));
    }

    private Runnable loggingRunnable(Task Task2, CarrotDashboardLogger logger, CountDownLatch countDownLatch) {
        return () -> {
            try {
                cn.boboweike.carrot.tasks.context.CarrotDashboardLogger.setTask((Task)Task2);
                for (int i = 0; i < 100; ++i) {
                    logger.info("info from " + Task2.getTaskName());
                    Thread.sleep(5L);
                }
                countDownLatch.countDown();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private Runnable serializingRunnable(Task task, CarrotDashboardLogger logger, TaskMapper taskMapper, CountDownLatch countDownLatch) {
        return () -> {
            try {
                cn.boboweike.carrot.tasks.context.CarrotDashboardLogger.setTask((Task)task);
                for (int i = 0; i < 100; ++i) {
                    taskMapper.serializeTask(task);
                    Thread.sleep(5L);
                }
                logger.info("successfully serialized Task " + task.getTaskName() + " 100 times");
                countDownLatch.countDown();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static class LogCondition
    extends Condition {
        private final TaskDashboardLogger.Level level;
        private final String message;

        protected LogCondition(TaskDashboardLogger.Level level, String message) {
            this.level = level;
            this.message = message;
        }

        public boolean matches(Object value) {
            Map metadata = (Map)ReflectionUtils.cast((Object)value);
            Object object = metadata.get("carrotDashboardLog-2");
            TaskDashboardLogger.TaskDashboardLogLines logLines = (TaskDashboardLogger.TaskDashboardLogLines)ReflectionUtils.cast(object);
            return logLines.getLogLines().stream().anyMatch(logLine -> this.level.equals((Object)logLine.getLevel()) && this.message.equals(logLine.getLogMessage()));
        }
    }

    private static class ErrorLog
    extends LogCondition {
        private ErrorLog(String message) {
            super(TaskDashboardLogger.Level.ERROR, message);
        }

        public static ErrorLog withMessage(String message) {
            return new ErrorLog(message);
        }
    }

    private static class WarnLog
    extends LogCondition {
        private WarnLog(String message) {
            super(TaskDashboardLogger.Level.WARN, message);
        }

        public static WarnLog withMessage(String message) {
            return new WarnLog(message);
        }
    }

    private static class InfoLog
    extends LogCondition {
        private InfoLog(String message) {
            super(TaskDashboardLogger.Level.INFO, message);
        }

        public static InfoLog withMessage(String message) {
            return new InfoLog(message);
        }
    }
}

