/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.context;

import cn.boboweike.carrot.fixtures.tasks.TaskAssert;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.context.TaskContext;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.gson.GsonJsonMapper;
import cn.boboweike.carrot.utils.mapper.jackson.JacksonJsonMapper;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;

public class TaskContextTest {
    @Test
    void TaskContextIsThreadSafeUsingJackson() throws InterruptedException {
        this.TaskContextIsThreadsafe(new TaskMapper((JsonMapper)new JacksonJsonMapper()));
    }

    @Test
    void TaskContextIsThreadSafeUsingGson() throws InterruptedException {
        this.TaskContextIsThreadsafe(new TaskMapper((JsonMapper)new GsonJsonMapper()));
    }

    void TaskContextIsThreadsafe(TaskMapper TaskMapper2) throws InterruptedException {
        Task Task2 = TaskTestBuilder.aTaskInProgress().withName("Task1").build();
        TaskContext TaskContext2 = new TaskContext(Task2);
        CountDownLatch countDownLatch = new CountDownLatch(2);
        Thread thread1 = new Thread(this.updateTaskContextRunnable(Task2, TaskContext2, countDownLatch));
        Thread thread2 = new Thread(this.serializingRunnable(Task2, TaskContext2, TaskMapper2, countDownLatch));
        thread1.start();
        thread2.start();
        countDownLatch.await(5L, TimeUnit.SECONDS);
        TaskAssert.assertThat(Task2).hasMetadata("key0", "value0").hasMetadata("key99", "value99");
    }

    private Runnable updateTaskContextRunnable(Task Task2, TaskContext TaskContext2, CountDownLatch countDownLatch) {
        return () -> {
            try {
                for (int i = 0; i < 100; ++i) {
                    TaskContext2.saveMetadata("key" + i, (Object)("value" + i));
                    Thread.sleep(5L);
                }
                countDownLatch.countDown();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private Runnable serializingRunnable(Task Task2, TaskContext TaskContext2, TaskMapper TaskMapper2, CountDownLatch countDownLatch) {
        return () -> {
            try {
                for (int i = 0; i < 100; ++i) {
                    TaskMapper2.serializeTask(Task2);
                    Thread.sleep(5L);
                }
                countDownLatch.countDown();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }
}

