/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.details;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.fixtures.stubs.TestServiceInterface;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.TaskParameter;
import cn.boboweike.carrot.tasks.context.TaskContext;
import cn.boboweike.carrot.tasks.details.TaskDetailsGenerator;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambda;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambdaFromStream;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import cn.boboweike.carrot.tasks.lambdas.TaskLambdaFromStream;
import cn.boboweike.carrot.utils.StringUtils;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.objectweb.asm.util.Textifier;

public abstract class AbstractTaskDetailsGeneratorTest {
    private TestService testService;
    private TestServiceInterface testServiceInterface;
    private TaskDetailsGenerator TaskDetailsGenerator;

    @BeforeEach
    void setUp() {
        this.TaskDetailsGenerator = this.getTaskDetailsGenerator();
        this.testService = new TestService();
        this.testServiceInterface = this.testService;
    }

    protected abstract TaskDetailsGenerator getTaskDetailsGenerator();

    protected TaskDetails toTaskDetails(TaskLambda Task2) {
        return this.TaskDetailsGenerator.toTaskDetails(Task2);
    }

    protected TaskDetails toTaskDetails(IocTaskLambda<TestService> iocTaskLambda) {
        return this.TaskDetailsGenerator.toTaskDetails(iocTaskLambda);
    }

    @Test
    @Disabled(value="for debugging")
    void logByteCode() {
        String location = "/Users/bobo/Projects/Personal/Carrot/Carrot/language-support/Carrot-kotlin-16-support/build/classes/kotlin/test/cn/boboweike/carrot/scheduling/TaskSchedulerTest.class";
        Assertions.assertThatCode(() -> Textifier.main((String[])new String[]{location})).doesNotThrowAnyException();
    }

    @Test
    void testTaskLambdaCallingSystemOutPrintln() {
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> System.out.println("This is a test!");
        TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(System.class).hasStaticFieldName("out").hasMethodName("println").hasArgs("This is a test!");
    }

    @Test
    void testTaskLambdaCallingInlineSystemOutPrintln() {
        TaskDetails TaskDetails2 = this.toTaskDetails((TaskLambda & Serializable)() -> System.out.println("This is a test!"));
        CarrotAssertions.assertThat(TaskDetails2).hasClass(System.class).hasStaticFieldName("out").hasMethodName("println").hasArgs("This is a test!");
    }

    @Test
    void testTaskLambdaContainingTwoStaticTasksShouldFailWithNiceException() {
        TaskLambda & Serializable TaskLambda2 = (TaskLambda & Serializable)() -> {
            System.out.println("This is a test!");
            System.out.println("This is a test!");
        };
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.toTaskDetails(TaskLambda2)).isInstanceOf(CarrotException.class)).hasMessage("Carrot only supports enqueueing/scheduling of one method");
    }

    @Test
    void testTaskLambdaContainingTwoTasksShouldFailWithNiceException() {
        TaskLambda & Serializable TaskLambda2 = (TaskLambda & Serializable)() -> {
            this.testService.doWork();
            this.testService.doWork();
        };
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.toTaskDetails(TaskLambda2)).isInstanceOf(CarrotException.class)).hasMessage("Carrot only supports enqueueing/scheduling of one method");
    }

    @Test
    void testTaskLambdaCallingStaticMethod() {
        UUID id = UUID.randomUUID();
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> TestService.doWorkInStaticMethod(id);
        TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWorkInStaticMethod").hasArgs(id);
    }

    @Test
    void testTaskLambdaCallingInlineStaticMethod() {
        UUID id = UUID.randomUUID();
        TaskDetails TaskDetails2 = this.toTaskDetails((TaskLambda & Serializable)() -> TestService.doWorkInStaticMethod(id));
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWorkInStaticMethod").hasArgs(id);
    }

    @Test
    void testTaskLambdaCallMethodReference() {
        TaskLambda & Serializable Task2 = this.testService::doWork;
        TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasNoArgs();
    }

    @Test
    void testTaskLambdaCallInstanceMethod_Null() {
        TestService.Work work = null;
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWork(work);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.toTaskDetails(Task2)).isInstanceOf(NullPointerException.class)).hasMessage("You are passing null as a parameter to your background task for type cn.boboweike.carrot.fixtures.stubs.TestService$Work - Carrot prevents this to fail fast.");
    }

    @Test
    void testTaskLambdaCallInstanceMethod_OtherLambda() {
        Supplier<Boolean> supplier = () -> {
            System.out.println("Dit is een test");
            return true;
        };
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> {
            if (((Boolean)supplier.get()).booleanValue()) {
                System.out.println("In nested lambda");
            }
        };
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.toTaskDetails(Task2)).isInstanceOf(IllegalArgumentException.class)).hasMessage("You are passing another (nested) Java 8 lambda to Carrot - this is not supported. Try to convert your lambda to a class or a method.");
    }

    @Test
    void testTaskLambdaCallInstanceMethod_BIPUSH() {
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWork(5);
        TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasArgs(5);
    }

    @Test
    void testTaskLambdaCallInstanceMethod_SIPUSH() {
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWorkThatTakesLong(500);
        TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWorkThatTakesLong").hasArgs(500);
    }

    @Test
    void testTaskLambdaCallInstanceMethod_LCONST() {
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWorkThatTakesLong(1L);
        TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWorkThatTakesLong").hasArgs(1L);
    }

    @Test
    void testInlineTaskLambdaCallInstanceMethod() {
        TaskDetails TaskDetails2 = this.toTaskDetails((TaskLambda & Serializable)() -> this.testService.doWork());
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasNoArgs();
    }

    @Test
    void testTaskLambdaWithIntegerAndTaskContext() {
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWork((Integer)3, TaskContext.Null);
        TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasArgs(3, TaskContext.Null);
    }

    @Test
    void testTaskLambdaWithDouble() {
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWork(3.3);
        TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasArgs(3.3);
    }

    @Test
    void testTaskLambdaWithSum() {
        int a = 6;
        int b = 3;
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWork(a + b);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.toTaskDetails(Task2)).isInstanceOf(IllegalArgumentException.class)).hasRootCauseInstanceOf(UnsupportedOperationException.class).hasRootCauseMessage("You are summing two numbers while enqueueing/scheduling tasks - for performance reasons it is better to do the calculation outside of the task lambda");
    }

    @Test
    void testTaskLambdaWithSubtraction() {
        int a = 6;
        int b = 3;
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWork(a - b);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.toTaskDetails(Task2)).isInstanceOf(IllegalArgumentException.class)).hasRootCauseInstanceOf(UnsupportedOperationException.class).hasRootCauseMessage("You are subtracting two numbers while enqueueing/scheduling tasks - for performance reasons it is better to do the calculation outside of the task lambda");
    }

    @Test
    void testTaskLambdaWithMultiplication() {
        int a = 6;
        int b = 3;
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWork(a * b);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.toTaskDetails(Task2)).isInstanceOf(IllegalArgumentException.class)).hasRootCauseInstanceOf(UnsupportedOperationException.class).hasRootCauseMessage("You are multiplying two numbers while enqueueing/scheduling tasks - for performance reasons it is better to do the calculation outside of the task lambda");
    }

    @Test
    void testTaskLambdaWithDivision() {
        int a = 6;
        int b = 3;
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWork(a / b);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.toTaskDetails(Task2)).isInstanceOf(IllegalArgumentException.class)).hasRootCauseInstanceOf(UnsupportedOperationException.class).hasRootCauseMessage("You are dividing two numbers while enqueueing/scheduling tasks - for performance reasons it is better to do the calculation outside of the task lambda");
    }

    @Test
    void testTaskLambdaWithMultipleInts() {
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWork(3, 97693);
        TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasArgs(3, 97693);
    }

    @Test
    void testTaskLambdaWithMultipleParameters() {
        int i = 0;
        while (i < 3) {
            int finalI = i++;
            Instant now = Instant.now();
            TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWork("some string", finalI, now);
            TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
            CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasArgs("some string", finalI, now);
        }
    }

    @Test
    void testTaskLambdaWithObject() {
        int i = 0;
        while (i < 3) {
            int finalI = i++;
            TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWork(new TestService.Work(finalI, "a String", UUID.randomUUID()));
            TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
            CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork");
            TaskParameter TaskParameter2 = (TaskParameter)TaskDetails2.getTaskParameters().get(0);
            Assertions.assertThat((String)TaskParameter2.getClassName()).isEqualTo(TestService.Work.class.getName());
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)TaskParameter2.getObject()).isInstanceOf(TestService.Work.class)).hasFieldOrPropertyWithValue("workCount", (Object)finalI)).hasFieldOrPropertyWithValue("someString", (Object)"a String")).hasFieldOrProperty("uuid");
        }
    }

    @Test
    void testTaskLambdaWithFile() {
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWorkWithFile(new File("/tmp/file.txt"));
        TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWorkWithFile");
        TaskParameter TaskParameter2 = (TaskParameter)TaskDetails2.getTaskParameters().get(0);
        Assertions.assertThat((String)TaskParameter2.getClassName()).isEqualTo(File.class.getName());
        ((ObjectAssert)Assertions.assertThat((Object)TaskParameter2.getObject()).isInstanceOf(File.class)).isEqualTo((Object)new File("/tmp/file.txt"));
    }

    @Test
    void testTaskLambdaWithPath() {
        Path path = Paths.get("/tmp/file.txt", new String[0]);
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWorkWithPath(path);
        TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWorkWithPath");
        TaskParameter TaskParameter2 = (TaskParameter)TaskDetails2.getTaskParameters().get(0);
        Assertions.assertThat((String)TaskParameter2.getClassName()).isEqualTo(Path.class.getName());
        ((ObjectAssert)Assertions.assertThat((Object)TaskParameter2.getObject()).isInstanceOf(Path.class)).isEqualTo((Object)path);
    }

    @Test
    void testTaskLambdaWithPathsGetInLambda() {
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWorkWithPath(Paths.get("/tmp/file.txt", new String[0]));
        TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWorkWithPath");
        TaskParameter TaskParameter2 = (TaskParameter)TaskDetails2.getTaskParameters().get(0);
        Assertions.assertThat((String)TaskParameter2.getClassName()).isEqualTo(Path.class.getName());
        ((ObjectAssert)Assertions.assertThat((Object)TaskParameter2.getObject()).isInstanceOf(Path.class)).isEqualTo((Object)Paths.get("/tmp/file.txt", new String[0]));
    }

    @Test
    void testTaskLambdaWithPaths() {
        for (int i = 0; i < 3; ++i) {
            Path path = Paths.get("/tmp/file" + i + ".txt", new String[0]);
            TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWorkWithPath(path);
            TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
            CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWorkWithPath");
            TaskParameter TaskParameter2 = (TaskParameter)TaskDetails2.getTaskParameters().get(0);
            Assertions.assertThat((String)TaskParameter2.getClassName()).isEqualTo(Path.class.getName());
            ((ObjectAssert)Assertions.assertThat((Object)TaskParameter2.getObject()).isInstanceOf(Path.class)).isEqualTo((Object)path);
        }
    }

    @Test
    void testTaskLambdaWithPathsGetMultiplePartsInLambda() {
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWorkWithPath(Paths.get("/tmp", "folder", "subfolder", "file.txt"));
        TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWorkWithPath");
        TaskParameter TaskParameter2 = (TaskParameter)TaskDetails2.getTaskParameters().get(0);
        Assertions.assertThat((String)TaskParameter2.getClassName()).isEqualTo(Path.class.getName());
        ((ObjectAssert)Assertions.assertThat((Object)TaskParameter2.getObject()).isInstanceOf(Path.class)).isEqualTo((Object)Paths.get("/tmp/folder/subfolder/file.txt", new String[0]));
    }

    @Test
    void testTaskLambdaWithPathOfInLambda() {
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWorkWithPath(Paths.get("/tmp/file.txt", new String[0]));
        TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWorkWithPath");
        TaskParameter TaskParameter2 = (TaskParameter)TaskDetails2.getTaskParameters().get(0);
        Assertions.assertThat((String)TaskParameter2.getClassName()).isEqualTo(Path.class.getName());
        ((ObjectAssert)Assertions.assertThat((Object)TaskParameter2.getObject()).isInstanceOf(Path.class)).isEqualTo((Object)Paths.get("/tmp/file.txt", new String[0]));
    }

    @Test
    void testTaskLambdaWithObjectCreatedOutsideOfLambda() {
        for (int i = 0; i < 3; ++i) {
            TestService.Work work = new TestService.Work(i, "a String", UUID.randomUUID());
            TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWork(work);
            TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
            CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork");
            TaskParameter TaskParameter2 = (TaskParameter)TaskDetails2.getTaskParameters().get(0);
            Assertions.assertThat((String)TaskParameter2.getClassName()).isEqualTo(TestService.Work.class.getName());
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)TaskParameter2.getObject()).isInstanceOf(TestService.Work.class)).hasFieldOrPropertyWithValue("workCount", (Object)i)).hasFieldOrPropertyWithValue("someString", (Object)"a String")).hasFieldOrPropertyWithValue("uuid", (Object)work.getUuid());
        }
    }

    @Test
    void testTaskLambdaWithSupportedPrimitiveTypes() {
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWork(true, 3, 5L, 3.3f, 2.3);
        TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasArgs(true, 3, 5L, Float.valueOf(3.3f), 2.3);
    }

    @Test
    void testTaskLambdaWithUnsupportedPrimitiveTypes() {
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> this.testService.doWork((byte)3, (short)2, 'c');
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.toTaskDetails(Task2)).isInstanceOf(CarrotException.class)).hasMessage("Error parsing lambda").hasCauseInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testTaskLambdaCallingMultiLine() {
        List workStream = this.getWorkStream().collect(Collectors.toList());
        Instant now = Instant.now();
        for (UUID id : workStream) {
            TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> {
                int someInt = 6;
                this.testService.doWork(id, someInt, now);
            };
            TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
            CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasArgs(id, 6, now);
        }
    }

    @Test
    void testTaskLambdaCallingMultiLineStatementSystemOutPrintln() {
        List workStream = this.getWorkStream().collect(Collectors.toList());
        LocalDateTime now = LocalDateTime.now();
        for (UUID id : workStream) {
            TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> {
                UUID testId = id;
                int someInt = 6;
                double someDouble = 5.3;
                float someFloat = 5.3f;
                long someLong = 3L;
                boolean someBoolean = true;
                SomeEnum someEnum = SomeEnum.Value1;
                System.out.println("This is a test: " + testId + "; " + someInt + "; " + someDouble + "; " + someFloat + "; " + someLong + "; " + someBoolean + "; " + someEnum + "; " + now);
            };
            TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
            CarrotAssertions.assertThat(TaskDetails2).hasClass(System.class).hasStaticFieldName("out").hasMethodName("println").hasArg(obj -> obj.toString().startsWith("This is a test: " + id) && obj.toString().contains(" 6; 5.3; 5.3; 3; true; Value1;") && obj.toString().contains(now.toString()));
        }
    }

    @Test
    void testTaskLambdaCallingMultiLineStatementThatLoadsFromAService() {
        TaskLambda & Serializable Task2 = (TaskLambda & Serializable)() -> {
            UUID testId = this.testService.getAnUUID();
            this.testService.doWork(testId);
        };
        TaskDetails TaskDetails2 = this.toTaskDetails(Task2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasArg(obj -> obj instanceof UUID);
    }

    @Test
    void testTaskLambdaWithArgumentThatIsNotUsed() {
        Stream<Integer> range = IntStream.range(0, 1).boxed();
        Assertions.assertThatCode(() -> this.TaskDetailsGenerator.toTaskDetails((Object)range, (TaskLambdaFromStream & Serializable)i -> this.testService.doWork())).doesNotThrowAnyException();
    }

    @Test
    void testTaskLambdaWithStaticMethodInLambda() {
        TaskLambda & Serializable TaskLambda2 = (TaskLambda & Serializable)() -> this.testService.doWork(TestService.Work.from(2, "a String", UUID.randomUUID()));
        TaskDetails TaskDetails2 = this.toTaskDetails(TaskLambda2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork");
        TaskParameter TaskParameter2 = (TaskParameter)TaskDetails2.getTaskParameters().get(0);
        Assertions.assertThat((String)TaskParameter2.getClassName()).isEqualTo(TestService.Work.class.getName());
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)TaskParameter2.getObject()).isInstanceOf(TestService.Work.class)).hasFieldOrPropertyWithValue("workCount", (Object)2)).hasFieldOrPropertyWithValue("someString", (Object)"a String")).hasFieldOrProperty("uuid");
    }

    @Test
    void testTaskLambdaWhichReturnsSomething() {
        TaskLambda & Serializable TaskLambda2 = (TaskLambda & Serializable)() -> this.testService.doWorkAndReturnResult("someString");
        TaskDetails TaskDetails2 = this.toTaskDetails(TaskLambda2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWorkAndReturnResult").hasArgs("someString");
    }

    @Test
    void testSimpleTaskLambdaWithStream() {
        List workStream = this.getWorkStream().collect(Collectors.toList());
        TaskLambdaFromStream & Serializable lambda = (TaskLambdaFromStream & Serializable)uuid -> this.testService.doWork((UUID)uuid, 3, Instant.now());
        List allTaskDetails = workStream.stream().map(x -> this.TaskDetailsGenerator.toTaskDetails(x, lambda)).collect(Collectors.toList());
        Assertions.assertThat(allTaskDetails).hasSize(5);
        CarrotAssertions.assertThat((TaskDetails)allTaskDetails.get(0)).hasClass(TestService.class).hasMethodName("doWork");
        Assertions.assertThat((Object)((TaskParameter)((TaskDetails)allTaskDetails.get(0)).getTaskParameters().get(0)).getObject()).isEqualTo(workStream.get(0));
        Assertions.assertThat((Object)((TaskParameter)((TaskDetails)allTaskDetails.get(4)).getTaskParameters().get(0)).getObject()).isEqualTo(workStream.get(4));
    }

    @Test
    void testTaskLambdaWithStream() {
        Stream<UUID> workStream = this.getWorkStream();
        AtomicInteger atomicInteger = new AtomicInteger();
        TaskLambdaFromStream & Serializable lambda = (TaskLambdaFromStream & Serializable)uuid -> this.testService.doWork(uuid.toString(), atomicInteger.incrementAndGet(), Instant.now());
        List allTaskDetails = workStream.map(x -> this.TaskDetailsGenerator.toTaskDetails(x, lambda)).collect(Collectors.toList());
        Assertions.assertThat(allTaskDetails).hasSize(5);
        CarrotAssertions.assertThat((TaskDetails)allTaskDetails.get(0)).hasClass(TestService.class).hasMethodName("doWork");
        Assertions.assertThat((Object)((TaskParameter)((TaskDetails)allTaskDetails.get(0)).getTaskParameters().get(1)).getObject()).isEqualTo((Object)1);
        Assertions.assertThat((Object)((TaskParameter)((TaskDetails)allTaskDetails.get(4)).getTaskParameters().get(1)).getObject()).isEqualTo((Object)5);
    }

    @Test
    void testTaskLambdaWithStreamAndObject() {
        List workStream = this.getWorkStream().collect(Collectors.toUnmodifiableList());
        AtomicInteger atomicInteger = new AtomicInteger();
        TaskLambdaFromStream & Serializable lambda = (TaskLambdaFromStream & Serializable)work -> this.testService.doWork((TestService.Work)work);
        List allTaskDetails = workStream.stream().map(uuid -> new TestService.Work(atomicInteger.getAndIncrement(), Integer.toString(atomicInteger.get()), (UUID)uuid)).map(x -> this.TaskDetailsGenerator.toTaskDetails(x, lambda)).collect(Collectors.toList());
        Assertions.assertThat(allTaskDetails).hasSize(5);
        CarrotAssertions.assertThat((TaskDetails)allTaskDetails.get(0)).hasClass(TestService.class).hasMethodName("doWork");
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)((TaskParameter)((TaskDetails)allTaskDetails.get(0)).getTaskParameters().get(0)).getObject()).isInstanceOf(TestService.Work.class)).hasFieldOrPropertyWithValue("someString", (Object)"1")).hasFieldOrPropertyWithValue("uuid", workStream.get(0));
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)((TaskParameter)((TaskDetails)allTaskDetails.get(4)).getTaskParameters().get(0)).getObject()).isInstanceOf(TestService.Work.class)).hasFieldOrPropertyWithValue("someString", (Object)"5")).hasFieldOrPropertyWithValue("uuid", workStream.get(4));
    }

    @Test
    void testTaskLambdaWithStreamAndMethodReference() {
        UUID uuid = UUID.randomUUID();
        TaskDetails TaskDetails2 = this.TaskDetailsGenerator.toTaskDetails((Object)uuid, TestService::doWorkWithUUID);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWorkWithUUID").hasArgs(uuid);
    }

    @Test
    void testTaskLambdaWithStreamAndMethodReferenceInSameFile() {
        UUID uuid = UUID.randomUUID();
        TaskDetails TaskDetails2 = this.TaskDetailsGenerator.toTaskDetails((Object)uuid, AbstractTaskDetailsGeneratorTest::doWorkWithUUID);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(AbstractTaskDetailsGeneratorTest.class).hasMethodName("doWorkWithUUID").hasArgs(uuid);
    }

    @Test
    void testIocTaskLambda() {
        IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.doWork();
        TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasNoArgs();
    }

    @Test
    void testInlineIocTaskLambda() {
        TaskDetails TaskDetails2 = this.TaskDetailsGenerator.toTaskDetails((IocTaskLambda & Serializable)x -> x.doWork(5));
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasArgs(5);
    }

    @Test
    void testIocTaskLambdaWithIntegerAndTaskContext() {
        IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.doWork((Integer)3, TaskContext.Null);
        TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasArgs(3, TaskContext.Null);
    }

    @Test
    void testIocTaskLambdaWithDouble() {
        IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.doWork(3.3);
        TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasArgs(3.3);
    }

    @Test
    void testIocTaskLambdaWithMultipleInts() {
        IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.doWork(3, 97693);
        TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasArgs(3, 97693);
    }

    @Test
    void testIocTaskLambdaWithMultipleParameters() {
        int i = 0;
        while (i < 3) {
            int finalI = i++;
            Instant now = Instant.now();
            IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.doWork("some string", finalI, now);
            TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
            CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasArgs("some string", finalI, now);
        }
    }

    @Test
    void testIocTaskLambdaWithObject() {
        int i = 0;
        while (i < 3) {
            int finalI = i++;
            IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.doWork(new TestService.Work(finalI, "a String", UUID.randomUUID()));
            TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
            CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork");
            TaskParameter TaskParameter2 = (TaskParameter)TaskDetails2.getTaskParameters().get(0);
            Assertions.assertThat((String)TaskParameter2.getClassName()).isEqualTo(TestService.Work.class.getName());
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)TaskParameter2.getObject()).isInstanceOf(TestService.Work.class)).hasFieldOrPropertyWithValue("workCount", (Object)finalI)).hasFieldOrPropertyWithValue("someString", (Object)"a String")).hasFieldOrProperty("uuid");
        }
    }

    @Test
    void testIoCTaskLambdaWithFile() {
        IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.doWorkWithFile(new File("/tmp/file.txt"));
        TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWorkWithFile");
        TaskParameter TaskParameter2 = (TaskParameter)TaskDetails2.getTaskParameters().get(0);
        Assertions.assertThat((String)TaskParameter2.getClassName()).isEqualTo(File.class.getName());
        ((ObjectAssert)Assertions.assertThat((Object)TaskParameter2.getObject()).isInstanceOf(File.class)).isEqualTo((Object)new File("/tmp/file.txt"));
    }

    @Test
    void testIoCTaskLambdaWithPath() {
        Path path = Paths.get("/tmp/file.txt", new String[0]);
        IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.doWorkWithPath(path);
        TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWorkWithPath");
        TaskParameter TaskParameter2 = (TaskParameter)TaskDetails2.getTaskParameters().get(0);
        Assertions.assertThat((String)TaskParameter2.getClassName()).isEqualTo(Path.class.getName());
        ((ObjectAssert)Assertions.assertThat((Object)TaskParameter2.getObject()).isInstanceOf(Path.class)).isEqualTo((Object)path);
    }

    @Test
    void testIocTaskLambdaWithObjectCreatedOutsideOfLambda() {
        for (int i = 0; i < 3; ++i) {
            TestService.Work work = new TestService.Work(i, "a String", UUID.randomUUID());
            IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.doWork(work);
            TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
            CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork");
            TaskParameter TaskParameter2 = (TaskParameter)TaskDetails2.getTaskParameters().get(0);
            Assertions.assertThat((String)TaskParameter2.getClassName()).isEqualTo(TestService.Work.class.getName());
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)TaskParameter2.getObject()).isInstanceOf(TestService.Work.class)).hasFieldOrPropertyWithValue("workCount", (Object)i)).hasFieldOrPropertyWithValue("someString", (Object)"a String")).hasFieldOrProperty("uuid");
        }
    }

    @Test
    void testIocTaskLambdaWithSupportedPrimitiveTypes() {
        IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.doWork(true, 3, 5L, 3.3f, 2.3);
        TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasArgs(true, 3, 5L, Float.valueOf(3.3f), 2.3);
    }

    @Test
    void testIocTaskLambdaWithSupportedPrimitiveTypes_LOAD() {
        for (int i = 0; i < 3; ++i) {
            boolean finalB = i % 2 == 0;
            int finalI = i;
            long finalL = 5L + (long)i;
            float finalF = 3.3f + (float)i;
            double finalD = 2.3 + (double)i;
            IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.doWork(finalB, finalI, finalL, finalF, finalD);
            TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
            CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasArgs(i % 2 == 0, finalI, 5L + (long)i, Float.valueOf(3.3f + (float)i), 2.3 + (double)i);
        }
    }

    @Test
    void testIocTaskLambdaWithPrimitiveWrappers_LOAD() {
        for (int i = 0; i < 3; ++i) {
            Boolean finalB = i % 2 == 0;
            Integer finalI = i;
            Long finalL = 5L + (long)i;
            Float finalF = Float.valueOf(3.3f + (float)i);
            Double finalD = 2.3 + (double)i;
            IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.doWork(finalB, finalI, finalL, finalF.floatValue(), finalD);
            TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
            CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasArgs(i % 2 == 0, finalI, 5L + (long)i, Float.valueOf(3.3f + (float)i), 2.3 + (double)i);
        }
    }

    @Test
    void testTaskLambdaWithPrimitiveParametersAndWrappersInMethod_LOAD() {
        long id = 1L;
        long env = 2L;
        String param = "test";
        TaskDetails TaskDetails2 = this.toTaskDetails((TaskLambda & Serializable)() -> this.testService.carrotBatchWrappers(id, env, param, TestUtils.getCurrentLogin()));
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("carrotBatchWrappers").hasArgs(1L, 2L, "test", "Some string");
    }

    @Test
    void testIoCTaskLambdaWithPrimitiveParametersAndWrappersInMethod_LOAD() {
        long id = 1L;
        long env = 2L;
        String param = "test";
        IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.carrotBatchWrappers(id, env, param, TestUtils.getCurrentLogin());
        TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("carrotBatchWrappers").hasArgs(1L, 2L, "test", "Some string");
    }

    @Test
    void testTaskLambdaWithPrimitiveParametersAndPrimitivesInMethod_LOAD() {
        long id = 1L;
        long env = 2L;
        String param = "test";
        TaskDetails TaskDetails2 = this.toTaskDetails((TaskLambda & Serializable)() -> this.testService.carrotBatchPrimitives(id, env, param, TestUtils.getCurrentLogin()));
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("carrotBatchPrimitives").hasArgs(1L, 2L, "test", "Some string");
    }

    @Test
    void testIoCTaskLambdaWithPrimitiveParametersAndPrimitivesInMethod_LOAD() {
        long id = 1L;
        long env = 2L;
        String param = "test";
        IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.carrotBatchPrimitives(id, env, param, TestUtils.getCurrentLogin());
        TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("carrotBatchPrimitives").hasArgs(1L, 2L, "test", "Some string");
    }

    @Test
    void testTaskLambdaWithCombinationParametersAndPrimitivesInMethod_LOAD() {
        long id = 1L;
        Long env = 2L;
        String param = "test";
        TaskDetails TaskDetails2 = this.toTaskDetails((TaskLambda & Serializable)() -> this.testService.carrotBatchPrimitives(id, env, param, TestUtils.getCurrentLogin()));
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("carrotBatchPrimitives").hasArgs(1L, 2L, "test", "Some string");
    }

    @Test
    void testIoCTaskLambdaWithCombinationParametersAndPrimitivesInMethod_LOAD() {
        long id = 1L;
        Long env = 2L;
        String param = "test";
        IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.carrotBatchPrimitives(id, env, param, TestUtils.getCurrentLogin());
        TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("carrotBatchPrimitives").hasArgs(1L, 2L, "test", "Some string");
    }

    @Test
    void testTaskLambdaWithCombinationParametersAndWrappersInMethod_LOAD() {
        long id = 1L;
        Long env = 2L;
        String param = "test";
        TaskDetails TaskDetails2 = this.toTaskDetails((TaskLambda & Serializable)() -> this.testService.carrotBatchWrappers(id, env, param, TestUtils.getCurrentLogin()));
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("carrotBatchWrappers").hasArgs(1L, 2L, "test", "Some string");
    }

    @Test
    void testIoCTaskLambdaWithCombinationParametersAndWrappersInMethod_LOAD() {
        long id = 1L;
        Long env = 2L;
        String param = "test";
        IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.carrotBatchPrimitives(id, env, param, TestUtils.getCurrentLogin());
        TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("carrotBatchPrimitives").hasArgs(1L, 2L, "test", "Some string");
    }

    @Test
    void testIocTaskLambdaWithUnsupportedPrimitiveTypes() {
        IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.doWork((byte)3, (short)2, 'c');
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda)).isInstanceOf(CarrotException.class)).hasMessage("Error parsing lambda").hasCauseInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testIocTaskLambdaWithArgumentThatIsNotUsed() {
        IocTaskLambdaFromStream & Serializable iocTaskLambdaFromStream = (IocTaskLambdaFromStream & Serializable)(x, i) -> x.doWork();
        Assertions.assertThatCode(() -> this.TaskDetailsGenerator.toTaskDetails((Object)5, iocTaskLambdaFromStream)).doesNotThrowAnyException();
    }

    @Test
    void testIocTaskLambdaWhichReturnsSomething() {
        IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.doWorkAndReturnResult("someString");
        TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)iocTaskLambda);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWorkAndReturnResult").hasArgs("someString");
    }

    @Test
    void testSimpleIoCTaskLambdaWithStream() {
        List workStream = this.getWorkStream().collect(Collectors.toList());
        IocTaskLambdaFromStream & Serializable lambda = (IocTaskLambdaFromStream & Serializable)(service, uuid) -> service.doWork((UUID)uuid, 5, Instant.now());
        List allTaskDetails = workStream.stream().map(x -> this.TaskDetailsGenerator.toTaskDetails(x, lambda)).collect(Collectors.toList());
        Assertions.assertThat(allTaskDetails).hasSize(5);
        CarrotAssertions.assertThat((TaskDetails)allTaskDetails.get(0)).hasClass(TestService.class).hasMethodName("doWork");
        Assertions.assertThat((Object)((TaskParameter)((TaskDetails)allTaskDetails.get(0)).getTaskParameters().get(0)).getObject()).isEqualTo(workStream.get(0));
        Assertions.assertThat((Object)((TaskParameter)((TaskDetails)allTaskDetails.get(4)).getTaskParameters().get(0)).getObject()).isEqualTo(workStream.get(4));
    }

    @Test
    void testIoCTaskLambdaWithStream() {
        Stream<UUID> workStream = this.getWorkStream();
        AtomicInteger atomicInteger = new AtomicInteger();
        IocTaskLambdaFromStream & Serializable lambda = (IocTaskLambdaFromStream & Serializable)(service, uuid) -> service.doWork(uuid.toString(), atomicInteger.incrementAndGet(), Instant.now());
        List allTaskDetails = workStream.map(x -> this.TaskDetailsGenerator.toTaskDetails(x, lambda)).collect(Collectors.toList());
        Assertions.assertThat(allTaskDetails).hasSize(5);
        CarrotAssertions.assertThat((TaskDetails)allTaskDetails.get(0)).hasClass(TestService.class).hasMethodName("doWork");
        Assertions.assertThat((Object)((TaskParameter)((TaskDetails)allTaskDetails.get(0)).getTaskParameters().get(1)).getObject()).isEqualTo((Object)1);
        Assertions.assertThat((Object)((TaskParameter)((TaskDetails)allTaskDetails.get(4)).getTaskParameters().get(1)).getObject()).isEqualTo((Object)5);
    }

    @Test
    void testIoCTaskWithStreamAndObject() {
        List workStream = this.getWorkStream().collect(Collectors.toUnmodifiableList());
        AtomicInteger atomicInteger = new AtomicInteger();
        IocTaskLambdaFromStream & Serializable lambda = (IocTaskLambdaFromStream & Serializable)(service, work) -> service.doWork((TestService.Work)work);
        List allTaskDetails = workStream.stream().map(uuid -> new TestService.Work(atomicInteger.getAndIncrement(), Integer.toString(atomicInteger.get()), (UUID)uuid)).map(x -> this.TaskDetailsGenerator.toTaskDetails(x, lambda)).collect(Collectors.toList());
        Assertions.assertThat(allTaskDetails).hasSize(5);
        CarrotAssertions.assertThat((TaskDetails)allTaskDetails.get(0)).hasClass(TestService.class).hasMethodName("doWork");
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)((TaskParameter)((TaskDetails)allTaskDetails.get(0)).getTaskParameters().get(0)).getObject()).isInstanceOf(TestService.Work.class)).hasFieldOrPropertyWithValue("someString", (Object)"1")).hasFieldOrPropertyWithValue("uuid", workStream.get(0));
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)((TaskParameter)((TaskDetails)allTaskDetails.get(4)).getTaskParameters().get(0)).getObject()).isInstanceOf(TestService.Work.class)).hasFieldOrPropertyWithValue("someString", (Object)"5")).hasFieldOrPropertyWithValue("uuid", workStream.get(4));
    }

    @Test
    void testIoCTaskLambdaWithStaticMethodInLambda() {
        IocTaskLambda & Serializable TaskLambda2 = (IocTaskLambda & Serializable)x -> x.doWork(TestService.Work.from(2, "a String", UUID.randomUUID()));
        TaskDetails TaskDetails2 = this.toTaskDetails((IocTaskLambda<TestService>)TaskLambda2);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork");
        TaskParameter TaskParameter2 = (TaskParameter)TaskDetails2.getTaskParameters().get(0);
        Assertions.assertThat((String)TaskParameter2.getClassName()).isEqualTo(TestService.Work.class.getName());
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)TaskParameter2.getObject()).isInstanceOf(TestService.Work.class)).hasFieldOrPropertyWithValue("workCount", (Object)2)).hasFieldOrPropertyWithValue("someString", (Object)"a String")).hasFieldOrProperty("uuid");
    }

    @Test
    void testInlineTaskLambdaFromInterface() {
        TaskDetails TaskDetails2 = this.toTaskDetails((TaskLambda & Serializable)() -> this.testServiceInterface.doWork());
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWork").hasNoArgs();
    }

    @Test
    void testMethodReferenceTaskLambdaFromInterface() {
        TaskDetails TaskDetails2 = this.toTaskDetails(this.testServiceInterface::doWork);
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestServiceInterface.class).hasMethodName("doWork").hasNoArgs();
    }

    @Test
    void testTaskLambdaWithEnum() {
        TaskDetails TaskDetails2 = this.toTaskDetails((TaskLambda & Serializable)() -> this.testService.doWorkWithEnum(TestService.Task.PROGRAMMING));
        CarrotAssertions.assertThat(TaskDetails2).hasClass(TestService.class).hasMethodName("doWorkWithEnum").hasArgs(new Object[]{TestService.Task.PROGRAMMING});
    }

    @Test
    void testTaskLambdaWithDifferentParametersCalledFromOtherMethod() {
        UUID uuid1 = UUID.randomUUID();
        CarrotAssertions.assertThat(this.createTaskDetails(uuid1)).hasClass(TestService.GithubIssue335.class).hasMethodName("run").hasArgs(uuid1);
        UUID uuid2 = UUID.randomUUID();
        CarrotAssertions.assertThat(this.createTaskDetails(uuid2)).hasClass(TestService.GithubIssue335.class).hasMethodName("run").hasArgs(uuid2);
    }

    @Test
    void TaskDetailsGeneratorIsThreadSafe() {
        UUID uuid1 = UUID.randomUUID();
        CarrotAssertions.assertThat(this.createTaskDetails(uuid1)).hasClass(TestService.GithubIssue335.class).hasMethodName("run").hasArgs(uuid1);
        UUID uuid2 = UUID.randomUUID();
        CarrotAssertions.assertThat(this.createTaskDetails(uuid2)).hasClass(TestService.GithubIssue335.class).hasMethodName("run").hasArgs(uuid2);
    }

    @Test
    void createTaskDetailsInMultipleThreadss() throws InterruptedException {
        CountDownLatch countDownLatch = new CountDownLatch(4);
        ConcurrentHashMap<String, TaskDetails> TaskDetailsResults = new ConcurrentHashMap<String, TaskDetails>();
        Thread thread1 = new Thread(this.createTaskDetailsRunnable(countDownLatch, "thread1", TaskDetailsResults));
        Thread thread2 = new Thread(this.createTaskDetailsRunnable(countDownLatch, "thread2", TaskDetailsResults));
        Thread thread3 = new Thread(this.createTaskDetailsRunnable(countDownLatch, "thread3", TaskDetailsResults));
        Thread thread4 = new Thread(this.createTaskDetailsRunnable(countDownLatch, "thread4", TaskDetailsResults));
        thread1.start();
        thread2.start();
        thread3.start();
        thread4.start();
        countDownLatch.await(100L, TimeUnit.SECONDS);
        CarrotAssertions.assertThat(TaskDetailsResults).hasSize(2000);
        TaskDetailsResults.keySet().stream().forEach(key -> {
            Integer givenInput = Integer.parseInt(StringUtils.substringAfterLast((String)key, (String)"-"));
            CarrotAssertions.assertThat((TaskDetails)TaskDetailsResults.get(key)).hasArgs(givenInput);
        });
    }

    private Runnable createTaskDetailsRunnable(CountDownLatch countDownLatch, String threadNbr, Map<String, TaskDetails> TaskDetailsResults) {
        Random random = new Random();
        return () -> {
            try {
                for (int i = 0; i < 500; ++i) {
                    Integer input = random.nextInt(1000);
                    TaskDetails TaskDetails2 = this.toTaskDetails((TaskLambda & Serializable)() -> this.testService.doWork(input));
                    TaskDetailsResults.put(threadNbr + "-" + i + "-" + input, TaskDetails2);
                    Thread.sleep(1L);
                }
                countDownLatch.countDown();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private TaskDetails createTaskDetails(UUID uuid) {
        return this.toTaskDetails((TaskLambda & Serializable)() -> new TestService.GithubIssue335().run(uuid));
    }

    private Stream<UUID> getWorkStream() {
        return IntStream.range(0, 5).mapToObj(i -> UUID.randomUUID());
    }

    public void doWorkWithUUID(UUID uuid) {
        System.out.println("Doing some work... " + uuid);
    }

    public static class TestUtils {
        public static String getCurrentLogin() {
            return "Some string";
        }
    }

    private static enum SomeEnum {
        Value1,
        Value2;

    }
}

