/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.details;

import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.details.AbstractTaskDetailsGeneratorTest;
import cn.boboweike.carrot.tasks.details.CachingTaskDetailsGenerator;
import cn.boboweike.carrot.tasks.details.TaskDetailsAsmGenerator;
import cn.boboweike.carrot.tasks.details.TaskDetailsGenerator;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambda;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import java.util.Set;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;

@ExtendWith(value={NotCacheableExceptionExtensionHandler.class})
public class CachingTaskDetailsGeneratorTest
extends AbstractTaskDetailsGeneratorTest {
    public static final Set<String> TESTS_WITH_TASK_DETAILS_THAT_ARE_NOT_CACHEABLE = Set.of("testIocTaskLambdaWithObject", "testTaskLambdaWithObject", "testTaskLambdaCallingMultiLineStatementSystemOutPrintln");

    @Override
    protected TaskDetailsGenerator getTaskDetailsGenerator() {
        return new CachingTaskDetailsGenerator((TaskDetailsGenerator)new TaskDetailsAsmGenerator());
    }

    @Override
    protected TaskDetails toTaskDetails(TaskLambda taskLambda) {
        TaskDetails taskDetails = super.toTaskDetails(taskLambda);
        CarrotAssertions.assertThat(taskDetails).isCacheable();
        return taskDetails;
    }

    @Override
    protected TaskDetails toTaskDetails(IocTaskLambda<TestService> iocTaskLambda) {
        TaskDetails taskDetails = super.toTaskDetails(iocTaskLambda);
        CarrotAssertions.assertThat(taskDetails).isCacheable();
        return taskDetails;
    }

    public static class NotCacheableExceptionExtensionHandler
    implements TestExecutionExceptionHandler {
        public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
            if (throwable instanceof AssertionError && TESTS_WITH_TASK_DETAILS_THAT_ARE_NOT_CACHEABLE.contains(context.getRequiredTestMethod().getName())) {
                return;
            }
            throw throwable;
        }
    }
}

