/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.details;

import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.details.TaskDetailsBuilder;
import cn.boboweike.carrot.tasks.details.TaskDetailsGeneratorUtils;
import cn.boboweike.carrot.tasks.details.instructions.ALoadOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.InvokeSpecialInstruction;
import cn.boboweike.carrot.tasks.details.instructions.InvokeVirtualInstruction;
import cn.boboweike.carrot.tasks.details.instructions.LdcInstruction;
import cn.boboweike.carrot.tasks.details.postprocess.TaskDetailsPostProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TaskDetailsBuilderPostProcessingTest {
    @Spy
    private TaskDetailsBuilder taskDetailsBuilder = this.getTaskDetailsBuilder();
    @Mock
    private TaskDetailsPostProcessor taskDetailsPostProcessor;

    @BeforeEach
    void setupTaskDetailsPostProcessor() {
        Mockito.when((Object)this.taskDetailsPostProcessor.postProcess((TaskDetails)ArgumentMatchers.any(TaskDetails.class))).thenAnswer(i -> i.getArguments()[0]);
    }

    @Test
    void assertPostProcessorsAreCalled() {
        new ALoadOperandInstruction(this.taskDetailsBuilder).load(1);
        new InvokeSpecialInstruction(this.taskDetailsBuilder).load("java/lang/StringBuilder", "<init>", "()V", false);
        new LdcInstruction(this.taskDetailsBuilder).load((Object)"Hello ");
        new InvokeVirtualInstruction(this.taskDetailsBuilder).load("java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        new ALoadOperandInstruction(this.taskDetailsBuilder).load(0);
        new InvokeVirtualInstruction(this.taskDetailsBuilder).load("java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        new InvokeVirtualInstruction(this.taskDetailsBuilder).load("java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        new InvokeVirtualInstruction(this.taskDetailsBuilder).load("cn/boboweike/carrot/fixtures/stubs/TestService", "doWork", "(Ljava/lang/String;)V", false);
        TaskDetails taskDetails = this.taskDetailsBuilder.getTaskDetails();
        ((TaskDetailsPostProcessor)Mockito.verify((Object)this.taskDetailsPostProcessor)).postProcess(taskDetails);
    }

    private TaskDetailsBuilder getTaskDetailsBuilder() {
        return new TaskDetailsBuilder(Arrays.asList("World", null), TaskDetailsGeneratorUtils.toFQClassName((String)"cn/boboweike/carrot/examples/webapp/api/TaskController"), "lambda$simpleTask$4ffb5ff$1"){

            List<TaskDetailsPostProcessor> getTaskDetailsPostProcessors() {
                ArrayList<TaskDetailsPostProcessor> taskDetailsPostProcessors = new ArrayList<TaskDetailsPostProcessor>(super.getTaskDetailsPostProcessors());
                taskDetailsPostProcessors.add(TaskDetailsBuilderPostProcessingTest.this.taskDetailsPostProcessor);
                return taskDetailsPostProcessors;
            }
        };
    }
}

