/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.details;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.details.TaskDetailsBuilder;
import cn.boboweike.carrot.tasks.details.TaskDetailsGeneratorUtils;
import cn.boboweike.carrot.tasks.details.instructions.ALoadOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.IConst2OperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.InvokeSpecialInstruction;
import cn.boboweike.carrot.tasks.details.instructions.InvokeVirtualInstruction;
import cn.boboweike.carrot.tasks.details.instructions.LdcInstruction;
import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TaskDetailsBuilderTest {
    @Test
    void reproduceIssueStringBuilderAppend() {
        TaskDetailsBuilder taskDetailsBuilder = this.getTaskDetailsBuilder();
        new ALoadOperandInstruction(taskDetailsBuilder).load(1);
        new InvokeSpecialInstruction(taskDetailsBuilder).load("java/lang/StringBuilder", "<init>", "()V", false);
        new LdcInstruction(taskDetailsBuilder).load((Object)"Hello ");
        new InvokeVirtualInstruction(taskDetailsBuilder).load("java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        new ALoadOperandInstruction(taskDetailsBuilder).load(0);
        new InvokeVirtualInstruction(taskDetailsBuilder).load("java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        new InvokeVirtualInstruction(taskDetailsBuilder).load("java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        new InvokeVirtualInstruction(taskDetailsBuilder).load("cn/boboweike/carrot/fixtures/stubs/TestService", "doWork", "(Ljava/lang/String;)V", false);
        TaskDetails taskDetails = taskDetailsBuilder.getTaskDetails();
        CarrotAssertions.assertThat(taskDetails).hasClass(TestService.class).hasMethodName("doWork").hasArgs("Hello World");
    }

    @Test
    void reproduceIssuePrivateMethod() {
        TaskDetailsBuilder taskDetailsBuilder = this.getTaskDetailsBuilder();
        new ALoadOperandInstruction(taskDetailsBuilder).load(0);
        new ALoadOperandInstruction(taskDetailsBuilder).load(1);
        new IConst2OperandInstruction(taskDetailsBuilder).load();
        new InvokeSpecialInstruction(taskDetailsBuilder).load("cn/boboweike/carrot/fixtures/stubs/TestService", "aPrivateMethod", "(Ljava/lang/String;I)V", false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TaskDetailsBuilder)taskDetailsBuilder).getTaskDetails()).isInstanceOf(CarrotException.class)).hasMessage("The lambda you provided is not valid.");
    }

    private TaskDetailsBuilder getTaskDetailsBuilder() {
        return new TaskDetailsBuilder(Arrays.asList("World", null), TaskDetailsGeneratorUtils.toFQClassName((String)"cn/boboweike/carrot/examples/webapp/api/TaskController"), "lambda$simpleTask$4ffb5ff$1"){};
    }
}

