/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.details.postprocess;

import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsAssert;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.details.postprocess.CGLibPostProcessor;
import org.junit.jupiter.api.Test;

public class CGLibPostProcessorTest {
    private CGLibPostProcessor cgLibPostProcessor = new CGLibPostProcessor();

    @Test
    void postProcessWithoutCGLibReturnsSameTaskDetails() {
        TaskDetails TaskDetails2 = TaskDetailsTestBuilder.defaultTaskDetails().build();
        TaskDetails result = this.cgLibPostProcessor.postProcess(TaskDetails2);
        CarrotAssertions.assertThat(result).isSameAs(TaskDetails2);
    }

    @Test
    void postProcessWithSpringCGLibReturnsUpdatedTaskDetails() {
        TaskDetails TaskDetails2 = TaskDetailsTestBuilder.defaultTaskDetails().withClassName(TestService.class.getName() + "$$EnhancerBySpringCGLIB$$6aee664d").build();
        TaskDetails result = this.cgLibPostProcessor.postProcess(TaskDetails2);
        ((TaskDetailsAssert)CarrotAssertions.assertThat(result).isNotSameAs(TaskDetails2)).hasClass(TestService.class);
    }

    @Test
    void postProcessWithCGLibReturnsUpdatedTaskDetails() {
        TaskDetails TaskDetails2 = TaskDetailsTestBuilder.defaultTaskDetails().withClassName(TestService.class.getName() + "$$EnhancerByCGLIB$$6aee664d").build();
        TaskDetails result = this.cgLibPostProcessor.postProcess(TaskDetails2);
        ((TaskDetailsAssert)CarrotAssertions.assertThat(result).isNotSameAs(TaskDetails2)).hasClass(TestService.class);
    }
}

