/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.filters;

import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.tasks.AbstractTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.filters.DisplayNameFilter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;

public class DisplayNameFilterTest {
    private DisplayNameFilter displayNameFilter;

    @BeforeEach
    void setup() {
        this.displayNameFilter = new DisplayNameFilter();
    }

    @Test
    void testDisplayNameWithAnnotationUsingTaskParametersAndMDCVariables() {
        MDC.put((String)"customer.id", (String)"1");
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.taskDetails().withClassName(TestService.class).withMethodName("doWorkWithAnnotation").withTaskParameter(5).withTaskParameter("John Doe")).build();
        this.displayNameFilter.onCreating((AbstractTask)task);
        Assertions.assertThat((String)task.getTaskName()).isEqualTo("Doing some hard work for user John Doe (customerId: 1)");
    }

    @Test
    void testDisplayNameWithAnnotationUsingTaskParametersAndMDCVariablesThatDoNotExist() {
        MDC.remove((String)"customer.id");
        MDC.put((String)"key-not-used-in-annotation", (String)"1");
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.taskDetails().withClassName(TestService.class).withMethodName("doWorkWithAnnotation").withTaskParameter(5).withTaskParameter("John Doe")).build();
        this.displayNameFilter.onCreating((AbstractTask)task);
        Assertions.assertThat((String)task.getTaskName()).isEqualTo("Doing some hard work for user John Doe (customerId: (customer.id is not found in MDC))");
    }

    @Test
    void testDisplayNameFromTaskDetailsNormalMethod() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.taskDetails().withClassName(TestService.class).withMethodName("doWork").withTaskParameter(5.5)).build();
        this.displayNameFilter.onCreating((AbstractTask)task);
        Assertions.assertThat((String)task.getTaskName()).isEqualTo("cn.boboweike.carrot.fixtures.stubs.TestService.doWork(5.5)");
    }

    @Test
    void testDisplayNameFromTaskDetailsStaticMethod() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.systemOutPrintLnTaskDetails("some message")).build();
        this.displayNameFilter.onCreating((AbstractTask)task);
        Assertions.assertThat((String)task.getTaskName()).isEqualTo("java.lang.System.out.println(some message)");
    }
}

