/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.filters;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.filters.RetryFilter;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambda;
import cn.boboweike.carrot.tasks.states.FailedState;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.tasks.states.TaskState;
import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class RetryFilterTest {
    private RetryFilter retryFilter;

    RetryFilterTest() {
    }

    @BeforeEach
    void setupRetryFilter() {
        this.retryFilter = new RetryFilter();
    }

    @Test
    void skipsIfTestIsNotFailed() {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        int beforeVersion = task.getTaskStates().size();
        this.retryFilter.onStateElection(task, task.getTaskState());
        int afterVersion = task.getTaskStates().size();
        Assertions.assertThat((int)afterVersion).isEqualTo(beforeVersion);
        Assertions.assertThat((Comparable)task.getState()).isEqualTo((Object)StateName.ENQUEUED);
    }

    @Test
    void retryFilterSchedulesTaskAgainIfItIsFailed() {
        Task task = TaskTestBuilder.aFailedTask().build();
        int beforeVersion = task.getTaskStates().size();
        this.retryFilter.onStateElection(task, task.getTaskState());
        int afterVersion = task.getTaskStates().size();
        Assertions.assertThat((int)afterVersion).isEqualTo(beforeVersion + 1);
        Assertions.assertThat((Comparable)task.getState()).isEqualTo((Object)StateName.SCHEDULED);
    }

    @Test
    void retryFilterSchedulesTaskAgainIfItIsFailedButMaxNumberOfRetriesIsNotReached() {
        Task task = TaskTestBuilder.aTask().withTaskDetails((IocTaskLambda & Serializable)ts -> ts.doWorkThatFails()).withState((TaskState)new FailedState("a message", (Exception)new RuntimeException("boem"))).build();
        int beforeVersion = task.getTaskStates().size();
        this.retryFilter.onStateElection(task, task.getTaskState());
        int afterVersion = task.getTaskStates().size();
        Assertions.assertThat((int)afterVersion).isEqualTo(beforeVersion + 1);
        Assertions.assertThat((Comparable)task.getState()).isEqualTo((Object)StateName.SCHEDULED);
    }

    @Test
    void retryFilterDoesNotScheduleTaskAgainIfMaxNumberOfRetriesIsReached() {
        Task task = TaskTestBuilder.aTask().withTaskDetails((IocTaskLambda & Serializable)ts -> ts.doWorkThatFails()).withState((TaskState)new FailedState("a message", (Exception)new RuntimeException("boem"))).withState((TaskState)new FailedState("firstRetry", (Exception)new RuntimeException("boem"))).build();
        int beforeVersion = task.getTaskStates().size();
        this.retryFilter.onStateElection(task, task.getTaskState());
        int afterVersion = task.getTaskStates().size();
        Assertions.assertThat((int)afterVersion).isEqualTo(beforeVersion);
        Assertions.assertThat((Comparable)task.getState()).isEqualTo((Object)StateName.FAILED);
    }

    @Test
    void retryFilterDoesNotScheduleTaskAgainIfTheExceptionIsProblematic() {
        Task task = TaskTestBuilder.aFailedTask().withState((TaskState)new FailedState("a message", (Exception)CarrotException.problematicConfigurationException((String)"big problem"))).build();
        int beforeVersion = task.getTaskStates().size();
        this.retryFilter.onStateElection(task, task.getTaskState());
        int afterVersion = task.getTaskStates().size();
        Assertions.assertThat((int)afterVersion).isEqualTo(beforeVersion);
        Assertions.assertThat((Comparable)task.getState()).isEqualTo((Object)StateName.FAILED);
    }

    @Test
    void retryFilterDoesNotScheduleTaskAgainIfItHasFailed10Times() {
        Task task = TaskTestBuilder.aFailedTaskWithRetries().build();
        int beforeVersion = task.getTaskStates().size();
        this.retryFilter.onStateElection(task, task.getTaskState());
        int afterVersion = task.getTaskStates().size();
        Assertions.assertThat((int)afterVersion).isEqualTo(beforeVersion);
        Assertions.assertThat((Comparable)task.getState()).isEqualTo((Object)StateName.FAILED);
    }

    @Test
    void retryFilterKeepsDefaultRetryFilterValueOf10IfRetriesOnTaskAnnotationIsNotProvided() {
        Task task = TaskTestBuilder.aTask().withTaskDetails((IocTaskLambda & Serializable)ts -> ts.doWork()).withState((TaskState)new FailedState("a message", (Exception)new RuntimeException("boem"))).build();
        int beforeVersion = task.getTaskStates().size();
        this.retryFilter.onStateElection(task, task.getTaskState());
        int afterVersion = task.getTaskStates().size();
        Assertions.assertThat((int)afterVersion).isEqualTo(beforeVersion + 1);
        Assertions.assertThat((Comparable)task.getState()).isEqualTo((Object)StateName.SCHEDULED);
    }

    @Test
    void retryFilterKeepsDefaultGivenRetryFilterValueIfRetriesOnTaskAnnotationIsNotProvided() {
        this.retryFilter = new RetryFilter(0);
        Task task = TaskTestBuilder.aTask().withTaskDetails((IocTaskLambda & Serializable)ts -> ts.doWork()).withState((TaskState)new FailedState("a message", (Exception)new RuntimeException("boem"))).build();
        int beforeVersion = task.getTaskStates().size();
        this.retryFilter.onStateElection(task, task.getTaskState());
        int afterVersion = task.getTaskStates().size();
        Assertions.assertThat((int)afterVersion).isEqualTo(beforeVersion);
        Assertions.assertThat((Comparable)task.getState()).isEqualTo((Object)StateName.FAILED);
    }

    @Test
    void retryFilterUsesValueOfRetriesOnTaskAnnotationIfProvided() {
        this.retryFilter = new RetryFilter(0);
        Task task = TaskTestBuilder.aTask().withTaskDetails((IocTaskLambda & Serializable)ts -> ts.doWorkThatFails()).withState((TaskState)new FailedState("a message", (Exception)new RuntimeException("boem"))).build();
        int beforeVersion = task.getTaskStates().size();
        this.retryFilter.onStateElection(task, task.getTaskState());
        int afterVersion = task.getTaskStates().size();
        Assertions.assertThat((int)afterVersion).isEqualTo(beforeVersion + 1);
        Assertions.assertThat((Comparable)task.getState()).isEqualTo((Object)StateName.SCHEDULED);
        task = TaskTestBuilder.aCopyOf(task).withState((TaskState)new FailedState("a message", (Exception)new RuntimeException("boem"))).build();
        beforeVersion = task.getTaskStates().size();
        this.retryFilter.onStateElection(task, task.getTaskState());
        afterVersion = task.getTaskStates().size();
        Assertions.assertThat((int)afterVersion).isEqualTo(beforeVersion);
        Assertions.assertThat((Comparable)task.getState()).isEqualTo((Object)StateName.FAILED);
    }
}

