/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.filters;

import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.filters.ApplyStateFilter;
import cn.boboweike.carrot.tasks.filters.TaskDefaultFilters;
import cn.boboweike.carrot.tasks.filters.TaskFilter;
import cn.boboweike.carrot.tasks.filters.TaskPerformingFilters;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.tasks.states.TaskState;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.internal.util.reflection.Whitebox;

public class TaskPerformingFiltersTest {
    private TestService testService;

    @BeforeEach
    void setUp() {
        this.testService = new TestService();
    }

    @Test
    void ifNoElectStateFilterIsProvidedTheDefaultRetryFilterIsUsed() {
        Task aTaskWithoutTaskFilters = TaskTestBuilder.aFailedTask().build();
        this.taskPerformingFilters(aTaskWithoutTaskFilters).runOnStateElectionFilter();
        Assertions.assertThat((List)aTaskWithoutTaskFilters.getTaskStates()).extracting("state").containsExactly(new Object[]{StateName.ENQUEUED, StateName.PROCESSING, StateName.FAILED, StateName.SCHEDULED});
    }

    @Test
    void ifElectStateFilterIsProvidedItIsUsed() {
        Task aTaskWithACustomElectStateTaskFilter = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> this.testService.doWorkWithCustomTaskFilters()).build();
        this.taskPerformingFilters(aTaskWithACustomElectStateTaskFilter).runOnStateElectionFilter();
        Assertions.assertThat((List)aTaskWithACustomElectStateTaskFilter.getTaskStates()).extracting("state").containsExactly(new Object[]{StateName.ENQUEUED, StateName.SUCCEEDED});
    }

    @Test
    void ifADefaultElectStateFilterIsProvidedItIsUsed() {
        TaskDefaultFilters taskDefaultFilters = new TaskDefaultFilters(new TaskFilter[]{new TestService.FailedToDeleteElectStateFilter()});
        Task aTaskWithoutTaskFilters = TaskTestBuilder.aFailedTask().build();
        this.taskPerformingFilters(aTaskWithoutTaskFilters, taskDefaultFilters).runOnStateElectionFilter();
        Assertions.assertThat((List)aTaskWithoutTaskFilters.getTaskStates()).extracting("state").containsExactly(new Object[]{StateName.ENQUEUED, StateName.PROCESSING, StateName.FAILED, StateName.DELETED});
    }

    @Test
    void ifOtherFilterIsProvidedItIsUsed() {
        Task aTaskWithACustomElectStateTaskFilter = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> this.testService.doWorkWithCustomTaskFilters()).build();
        TaskPerformingFilters taskPerformingFilters = this.taskPerformingFilters(aTaskWithACustomElectStateTaskFilter);
        taskPerformingFilters.runOnStateAppliedFilters();
        taskPerformingFilters.runOnTaskProcessingFilters();
        taskPerformingFilters.runOnTaskProcessedFilters();
        Map metadata = (Map)Whitebox.getInternalState(aTaskWithACustomElectStateTaskFilter, "metadata");
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)metadata).containsKey((Object)"onStateApplied")).containsKey((Object)"onProcessing")).containsKey((Object)"onProcessed");
    }

    @Test
    void exceptionsAreCatched() {
        TaskDefaultFilters taskDefaultFilters = new TaskDefaultFilters(new TaskFilter[]{new TaskFilterThatThrowsAnException()});
        Task aTaskWithoutTaskFilters = TaskTestBuilder.aFailedTask().build();
        this.taskPerformingFilters(aTaskWithoutTaskFilters, taskDefaultFilters).runOnStateAppliedFilters();
        Assertions.assertThat((List)aTaskWithoutTaskFilters.getTaskStates()).extracting("state").containsExactly(new Object[]{StateName.ENQUEUED, StateName.PROCESSING, StateName.FAILED});
    }

    @Test
    void noExceptionIsThrownIfTaskClassIsNotFound() {
        Task aTaskClassThatDoesNotExist = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.classThatDoesNotExistTaskDetails()).build();
        Assertions.assertThatCode(() -> this.taskPerformingFilters(aTaskClassThatDoesNotExist).runOnStateElectionFilter()).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.taskPerformingFilters(aTaskClassThatDoesNotExist).runOnStateAppliedFilters()).doesNotThrowAnyException();
    }

    @Test
    void noExceptionIsThrownIfTaskMethodIsNotFound() {
        Task aTaskMethodThatDoesNotExist = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.methodThatDoesNotExistTaskDetails()).build();
        Assertions.assertThatCode(() -> this.taskPerformingFilters(aTaskMethodThatDoesNotExist).runOnStateElectionFilter()).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.taskPerformingFilters(aTaskMethodThatDoesNotExist).runOnStateAppliedFilters()).doesNotThrowAnyException();
    }

    private TaskPerformingFilters taskPerformingFilters(Task task) {
        return this.taskPerformingFilters(task, new TaskDefaultFilters(new TaskFilter[0]));
    }

    private TaskPerformingFilters taskPerformingFilters(Task task, TaskDefaultFilters taskDefaultFilters) {
        return new TaskPerformingFilters(task, taskDefaultFilters);
    }

    private static class TaskFilterThatThrowsAnException
    implements ApplyStateFilter {
        private TaskFilterThatThrowsAnException() {
        }

        public void onStateApplied(Task task, TaskState oldState, TaskState newState) {
            throw new RuntimeException("boem!");
        }
    }
}

