/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.mappers;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.fixtures.tasks.RecurringTaskTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.server.runner.RunnerTaskContext;
import cn.boboweike.carrot.tasks.RecurringTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskParameter;
import cn.boboweike.carrot.tasks.TaskParameterNotDeserializableException;
import cn.boboweike.carrot.tasks.context.TaskContext;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.tasks.states.ProcessingState;
import cn.boboweike.carrot.tasks.states.TaskState;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.TaskParameterJsonMapperException;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
abstract class TaskMapperTest {
    @Mock
    private BackgroundTaskServer backgroundTaskServer;
    private TestService testService;
    private TaskMapper taskMapper;

    TaskMapperTest() {
    }

    @BeforeEach
    void setUp() {
        this.taskMapper = new TaskMapper(this.getJsonMapper());
        this.testService = new TestService();
        Mockito.lenient().when((Object)this.backgroundTaskServer.getId()).thenReturn((Object)UUID.randomUUID());
    }

    protected abstract JsonMapper getJsonMapper();

    @Test
    void testSerializeAndDeserializeTaskWithVersion() {
        Task task = TaskTestBuilder.anEnqueuedTask().withVersion(2).build();
        String taskAsString = this.taskMapper.serializeTask(task);
        Task actualTask = this.taskMapper.deserializeTask(taskAsString);
        CarrotAssertions.assertThat(actualTask).isEqualTo(task);
    }

    @Test
    void testSerializeAndDeserializeProcessingTaskWithLogs() {
        Task task = TaskTestBuilder.anEnqueuedTask().withState((TaskState)new ProcessingState(UUID.randomUUID())).build();
        RunnerTaskContext taskContext = new RunnerTaskContext(task);
        taskContext.logger().info("test 1");
        taskContext.logger().warn("test 2");
        taskContext.progressBar(10).setValue(4);
        String taskAsString = this.taskMapper.serializeTask(task);
        CarrotAssertions.assertThatJson(taskAsString).isEqualTo((Object)CarrotAssertions.contentOfResource("/cn/boboweike/carrot/tasks/mappers/task-in-progress-with-logs-and-progressbar.json"));
        Task actualTask = this.taskMapper.deserializeTask(taskAsString);
        CarrotAssertions.assertThat(actualTask).isEqualTo(task);
    }

    @Test
    void testSerializeAndDeserializeTaskWithPath() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> this.testService.doWorkWithPath(Paths.get("/tmp", "taskrunr", "log.txt"))).build();
        String taskAsString = this.taskMapper.serializeTask(task);
        Assertions.assertThatCode(() -> this.taskMapper.deserializeTask(taskAsString)).doesNotThrowAnyException();
    }

    @Test
    void serializeAndDeserializeRecurringTask() {
        RecurringTask recurringTask = RecurringTaskTestBuilder.aDefaultRecurringTask().build();
        String taskAsString = this.taskMapper.serializeRecurringTask(recurringTask);
        RecurringTask actualRecurringTask = this.taskMapper.deserializeRecurringTask(taskAsString);
        CarrotAssertions.assertThat(actualRecurringTask).isEqualTo(recurringTask);
    }

    @Test
    void canSerializeAndDeserializeWithTaskContext() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.taskDetails().withClassName(TestService.class).withMethodName("doWork").withTaskParameter(5).withTaskParameter(TaskParameter.TaskContext)).build();
        String taskAsJson = this.taskMapper.serializeTask(task);
        Task actualTask = this.taskMapper.deserializeTask(taskAsJson);
        CarrotAssertions.assertThat(actualTask).isEqualTo(task);
    }

    @Test
    void canSerializeAndDeserializeTaskWithAllStatesAndMetadata() {
        Task task = TaskTestBuilder.anEnqueuedTask().withMetadata("metadata1", new TestMetadata("input")).withMetadata("metadata2", "a string").withMetadata("metadata3", 15.1).withMetadata("metadata6", 16.0).withMetadata("metadata7", true).build();
        task.startProcessingOn(this.backgroundTaskServer);
        task.failed("exception", new Exception("Test"));
        task.enqueue();
        task.succeeded();
        String taskAsJson = this.taskMapper.serializeTask(task);
        Task actualTask = this.taskMapper.deserializeTask(taskAsJson);
        CarrotAssertions.assertThat(actualTask).isEqualTo(task);
    }

    @Test
    void onIllegalTaskParameterCorrectExceptionIsThrown() {
        TestService.IllegalWork illegalWork = new TestService.IllegalWork(5L);
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> this.testService.doIllegalWork(illegalWork)).build();
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.taskMapper.serializeTask(task)).isInstanceOf(TaskParameterJsonMapperException.class)).isNotExactlyInstanceOf(CarrotException.class);
    }

    @Test
    void onTaskWithParameterThatCannotBeDeserializedAnymoreNoExceptionIsThrown() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.taskParameterThatDoesNotExistTaskDetails()).build();
        String taskAsJson = this.taskMapper.serializeTask(task);
        Task actualTask = this.taskMapper.deserializeTask(taskAsJson);
        CarrotAssertions.assertThat(actualTask).isNotNull();
        CarrotAssertions.assertThat(actualTask.getTaskDetails()).hasClassName(TestService.class.getName()).hasMethodName("doWork").hasArg(arg -> arg instanceof TaskParameterNotDeserializableException && ((TaskParameterNotDeserializableException)arg).getClassName().equals("i.dont.exist.Class"));
        String taskAsJsonAfterDeserialization = this.taskMapper.serializeTask(actualTask);
        Task actualTaskAfterDeserialization = this.taskMapper.deserializeTask(taskAsJsonAfterDeserialization);
        CarrotAssertions.assertThat(actualTaskAfterDeserialization.getTaskDetails()).hasClassName(TestService.class.getName()).hasMethodName("doWork").hasArg(arg -> arg instanceof TaskParameterNotDeserializableException && ((TaskParameterNotDeserializableException)arg).getClassName().equals("i.dont.exist.Class"));
    }

    public static class TestMetadata
    implements TaskContext.Metadata {
        private String input;
        private Instant instant;
        private Path path;
        private File file;

        protected TestMetadata() {
        }

        public TestMetadata(String input) {
            this.input = input;
            this.instant = Instant.now();
            this.path = Paths.get("/tmp", new String[0]);
            this.file = new File("/tmp");
        }

        public String getInput() {
            return this.input;
        }

        public Instant getInstant() {
            return this.instant;
        }

        public Path getPath() {
            return this.path;
        }

        public File getFile() {
            return this.file;
        }
    }
}

