/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.states;

import cn.boboweike.carrot.scheduling.exceptions.TaskNotFoundException;
import cn.boboweike.carrot.tasks.states.FailedState;
import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FailedStateTest {
    @Test
    void getExceptionWithoutMessage() {
        FailedState failedState = new FailedState("Carrot message", (Exception)new CustomException());
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)failedState.getException()).isInstanceOf(CustomException.class)).hasMessage(null);
    }

    @Test
    void getExceptionWithMessage() {
        FailedState failedState = new FailedState("Carrot message", (Exception)new CustomException("custom exception message"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)failedState.getException()).isInstanceOf(CustomException.class)).hasMessage("custom exception message");
    }

    @Test
    void getExceptionWithNestedException() {
        FailedState failedState = new FailedState("Carrot message", (Exception)new CustomException(new CustomException()));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)failedState.getException()).isInstanceOf(CustomException.class)).hasCauseInstanceOf(CustomException.class);
    }

    @Test
    void getExceptionWithMessageAndNestedException() {
        FailedState failedState = new FailedState("Carrot message", (Exception)new CustomException("custom exception message", new CustomException()));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)failedState.getException()).isInstanceOf(CustomException.class)).hasMessage("custom exception message").hasCauseInstanceOf(CustomException.class);
    }

    @Test
    void getExceptionWithMessageAndNestedExceptionWithMessage() {
        FailedState failedState = new FailedState("Carrot message", (Exception)new CustomException("custom exception message", new CustomException("other exception")));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)failedState.getException()).isInstanceOf(CustomException.class)).hasMessage("custom exception message").hasCauseInstanceOf(CustomException.class).hasRootCauseMessage("other exception");
    }

    @Test
    void getExceptionThatCannotReconstruct() {
        FailedState failedState = new FailedState("Carrot message", (Exception)new CustomExceptionThatCannotReconstruct(UUID.randomUUID()));
        Assertions.assertThatThrownBy(() -> ((FailedState)failedState).getException()).isInstanceOf(TaskNotFoundException.class);
    }

    public static class CustomExceptionThatCannotReconstruct
    extends Exception {
        public CustomExceptionThatCannotReconstruct(UUID id) {
            super(id.toString());
        }
    }

    public static class CustomException
    extends Exception {
        public CustomException() {
        }

        public CustomException(String message) {
            super(message);
        }

        public CustomException(String message, Throwable cause) {
            super(message, cause);
        }

        public CustomException(Throwable cause) {
            super(cause);
        }
    }
}

