/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils;

import cn.boboweike.carrot.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;

class CollectionUtilsTest {
    CollectionUtilsTest() {
    }

    @Test
    void isNullOrEmptyIsTrueForNullCollection() {
        Assertions.assertThat((boolean)CollectionUtils.isNullOrEmpty((Collection)null)).isTrue();
    }

    @Test
    void isNullOrEmptyIsTrueForEmptyCollection() {
        Assertions.assertThat((boolean)CollectionUtils.isNullOrEmpty(new ArrayList())).isTrue();
    }

    @Test
    void isNullOrEmptyIsFalseForNotEmptyCollection() {
        Assertions.assertThat((boolean)CollectionUtils.isNullOrEmpty(Arrays.asList("item"))).isFalse();
    }

    @Test
    void isNotNullOrEmptyIsFalseForNullCollection() {
        Assertions.assertThat((boolean)CollectionUtils.isNotNullOrEmpty((Collection)null)).isFalse();
    }

    @Test
    void isNotNullOrEmptyIsFalseForEmptyCollection() {
        Assertions.assertThat((boolean)CollectionUtils.isNotNullOrEmpty(new ArrayList())).isFalse();
    }

    @Test
    void isNotNullOrEmptyIsTrueForNotEmptyCollection() {
        Assertions.assertThat((boolean)CollectionUtils.isNotNullOrEmpty(Arrays.asList("item"))).isTrue();
    }

    @Test
    void isNullOrEmptyIsFalseForNotEmptyArray() {
        Assertions.assertThat((boolean)CollectionUtils.isNullOrEmpty((Object[])new String[]{"item1", "item2"})).isFalse();
    }

    @Test
    void isNullOrEmptyIsTrueForEmptyArray() {
        Assertions.assertThat((boolean)CollectionUtils.isNullOrEmpty((Object[])new String[0])).isTrue();
    }

    @Test
    void isNotNullOrEmptyIsFalseForEmptyArray() {
        Assertions.assertThat((boolean)CollectionUtils.isNotNullOrEmpty((Object[])new String[0])).isFalse();
    }

    @Test
    void testMapOf1() {
        Map map = CollectionUtils.mapOf((Object)"key1", (Object)"value1");
        Assertions.assertThat((Map)map).containsEntry((Object)"key1", (Object)"value1");
    }

    @Test
    void testMapOf2() {
        Map map = CollectionUtils.mapOf((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2");
        ((MapAssert)Assertions.assertThat((Map)map).containsEntry((Object)"key1", (Object)"value1")).containsEntry((Object)"key2", (Object)"value2");
    }
}

