/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(GCUtils.class);

    public static void simulateStopTheWorldGC(long howLongInMillis) {
        LOGGER.info("Simulating stop the world GC for {} sec", (Object)TimeUnit.MILLISECONDS.toSeconds(howLongInMillis));
        new MemoryExhauster(howLongInMillis - 500L).start();
        GCUtils.callFullGCFor(howLongInMillis);
    }

    private static void callFullGCFor(long millis) {
        long timestamp = System.currentTimeMillis();
        while (timestamp + millis > System.currentTimeMillis()) {
            System.gc();
        }
    }

    public static class MemoryExhauster
    extends Thread {
        private final long forHowLong;

        public MemoryExhauster(long howLongInMillis) {
            this.forHowLong = howLongInMillis;
        }

        @Override
        public void run() {
            long timestamp = System.currentTimeMillis();
            while (timestamp + this.forHowLong > System.currentTimeMillis()) {
                MemoryExhauster.tryToAllocateAllAvailableMemory();
            }
        }

        public static void tryToAllocateAllAvailableMemory() {
            try {
                int size;
                ArrayList<Object[]> allocations = new ArrayList<Object[]>();
                while ((size = (int)Runtime.getRuntime().freeMemory()) > 0) {
                    Object[] part = new Object[Math.min(size, Integer.MAX_VALUE)];
                    allocations.add(part);
                }
            }
            catch (OutOfMemoryError e) {
                LOGGER.debug("Out of memory exception happened", (Throwable)e);
            }
        }
    }
}

