/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils;

import cn.boboweike.carrot.utils.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StringUtilsTest {
    StringUtilsTest() {
    }

    @Test
    void testIsNullOrEmpty() {
        Assertions.assertThat((boolean)StringUtils.isNullOrEmpty(null)).isTrue();
        Assertions.assertThat((boolean)StringUtils.isNullOrEmpty((String)"")).isTrue();
        Assertions.assertThat((boolean)StringUtils.isNullOrEmpty((String)"bla")).isFalse();
    }

    @Test
    void testIsNotNullOrEmpty() {
        Assertions.assertThat((boolean)StringUtils.isNotNullOrEmpty(null)).isFalse();
        Assertions.assertThat((boolean)StringUtils.isNotNullOrEmpty((String)"")).isFalse();
        Assertions.assertThat((boolean)StringUtils.isNotNullOrEmpty((String)"bla")).isTrue();
    }

    @Test
    void testCapitalize() {
        Assertions.assertThat((String)StringUtils.capitalize((String)"testMethod")).isEqualTo("TestMethod");
    }

    @Test
    void testSubstringBeforeSplitterSingleChar() {
        Assertions.assertThat((String)StringUtils.substringBefore((String)"15", (String)"-")).isEqualTo("15");
        Assertions.assertThat((String)StringUtils.substringBefore((String)"15-ea", (String)"-")).isEqualTo("15");
    }

    @Test
    void testSubstringBeforeSplitterMultiChar() {
        Assertions.assertThat((String)StringUtils.substringBefore((String)"this is a test", (String)" is ")).isEqualTo("this");
        Assertions.assertThat((String)StringUtils.substringBefore((String)"this is a test", (String)" was ")).isEqualTo("this is a test");
    }

    @Test
    void testSubstringBeforeLast() {
        String input = "jar:file:/home/bobo/Projects/Personal/Carrot/bugs/carrot_issue/target/demo-0.0.1-SNAPSHOT.jar!/BOOT-INF/lib/carrot-1.0.0-SNAPSHOT.jar!/cn/boboweike/carrot/storage/sql/common/migrations";
        Assertions.assertThat((String)StringUtils.substringBeforeLast((String)input, (String)"!")).isEqualTo("jar:file:/home/bobo/Projects/Personal/Carrot/bugs/carrot_issue/target/demo-0.0.1-SNAPSHOT.jar!/BOOT-INF/lib/carrot-1.0.0-SNAPSHOT.jar");
    }

    @Test
    void testSubstringAfterSplitterSingleChar() {
        Assertions.assertThat((String)StringUtils.substringAfter((String)"15", (String)"-")).isNull();
        Assertions.assertThat((String)StringUtils.substringAfter((String)"15-ea", (String)"-")).isEqualTo("ea");
    }

    @Test
    void testSubstringAfterSplitterMultiChar() {
        Assertions.assertThat((String)StringUtils.substringAfter((String)"this is a test", (String)" is ")).isEqualTo("a test");
        Assertions.assertThat((String)StringUtils.substringAfter((String)"this is a test", (String)" was ")).isNull();
    }

    @Test
    void testSubstringAfterLast() {
        String input = "jar:file:/home/bobo/Projects/Personal/Carrot/bugs/carrot_issue/target/demo-0.0.1-SNAPSHOT.jar!/BOOT-INF/lib/carrot-1.0.0-SNAPSHOT.jar!/cn/boboweike/carrot/storage/sql/common/migrations";
        Assertions.assertThat((String)StringUtils.substringAfterLast((String)input, (String)"!")).isEqualTo("/cn/boboweike/carrot/storage/sql/common/migrations");
    }

    @Test
    void testSubstringBetween() {
        Assertions.assertThat((String)StringUtils.substringBetween((String)"${some.string}", (String)"${", (String)"}")).isEqualTo("some.string");
        Assertions.assertThat((String)StringUtils.substringBetween((String)"some.string", (String)"${", (String)"}")).isNull();
    }
}

