/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils.mapper;

import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.fixtures.tasks.RecurringTaskTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.server.runner.RunnerTaskContext;
import cn.boboweike.carrot.tasks.RecurringTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.context.TaskContext;
import cn.boboweike.carrot.tasks.context.TaskDashboardProgressBar;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import cn.boboweike.carrot.tasks.states.EnqueuedState;
import cn.boboweike.carrot.tasks.states.TaskState;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import java.io.Serializable;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.UUID;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractJsonMapperTest {
    protected JsonMapper jsonMapper;
    private TestService testService;

    @BeforeEach
    void setUp() {
        this.jsonMapper = this.newJsonMapper();
        this.testService = new TestService();
    }

    public abstract JsonMapper newJsonMapper();

    @Test
    void testSerializeAndDeserializeEnqueuedTask() {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        String taskAsString = this.jsonMapper.serialize((Object)task);
        CarrotAssertions.assertThatJson(taskAsString).isEqualTo((Object)CarrotAssertions.contentOfResource("/cn/boboweike/carrot/utils/mapper/enqueued-task.json"));
        Task actualTask = (Task)this.jsonMapper.deserialize(taskAsString, Task.class);
        CarrotAssertions.assertThat(actualTask).isEqualTo(task);
    }

    @Test
    void testSerializeAndDeserializeEnqueuedTaskWithCustomObject() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> this.testService.doWork(new TestService.Work(3, "a String", UUID.randomUUID()))).build();
        String taskAsString = this.jsonMapper.serialize((Object)task);
        CarrotAssertions.assertThatJson(taskAsString).isEqualTo((Object)CarrotAssertions.contentOfResource("/cn/boboweike/carrot/utils/mapper/enqueued-task-custom-object-parameter.json"));
        Task actualTask = (Task)this.jsonMapper.deserialize(taskAsString, Task.class);
        CarrotAssertions.assertThat(actualTask).isEqualTo(task);
    }

    @Test
    void testSerializeAndDeserializeWithTaskContext() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> this.testService.doWork((Integer)5, TaskContext.Null)).build();
        String taskAsString = this.jsonMapper.serialize((Object)task);
        CarrotAssertions.assertThatJson(taskAsString).isEqualTo((Object)CarrotAssertions.contentOfResource("/cn/boboweike/carrot/utils/mapper/enqueued-task-null-taskcontext.json"));
        Task actualTask = (Task)this.jsonMapper.deserialize(taskAsString, Task.class);
        CarrotAssertions.assertThat(actualTask).isEqualTo(task);
    }

    @Test
    void testSerializeAndDeserializeTaskInProgressWithLoggingAndProgressBar() {
        Task task = TaskTestBuilder.aTaskInProgress().build();
        RunnerTaskContext taskContext = new RunnerTaskContext(task);
        taskContext.logger().info("this is an info message");
        taskContext.logger().warn("this is a warning message");
        taskContext.logger().error("this is an error message");
        TaskDashboardProgressBar progressBar = taskContext.progressBar(80);
        progressBar.setValue(10);
        String taskAsString = this.jsonMapper.serialize((Object)task);
        CarrotAssertions.assertThatJson(taskAsString).isEqualTo((Object)CarrotAssertions.contentOfResource("/cn/boboweike/carrot/utils/mapper/task-in-progress-with-progressbar-and-logging.json"));
        Task actualTask = (Task)this.jsonMapper.deserialize(taskAsString, Task.class);
        CarrotAssertions.assertThat(actualTask).isEqualTo(task);
    }

    @Test
    void testSerializeAndDeserializeEnqueuedTaskWithInstantTaskParameter() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> this.testService.doWork(UUID.randomUUID(), 3, Instant.now())).build();
        String taskAsString = this.jsonMapper.serialize((Object)task);
        CarrotAssertions.assertThatJson(taskAsString).isEqualTo((Object)CarrotAssertions.contentOfResource("/cn/boboweike/carrot/utils/mapper/enqueued-task-instant-parameter.json"));
        Task actualTask = (Task)this.jsonMapper.deserialize(taskAsString, Task.class);
        CarrotAssertions.assertThat(actualTask).isEqualTo(task);
    }

    @Test
    void testSerializeAndDeserializeEnqueuedTaskWithLocalDateTimeTaskParameter() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> this.testService.doWork(LocalDateTime.now())).build();
        String taskAsString = this.jsonMapper.serialize((Object)task);
        CarrotAssertions.assertThatJson(taskAsString).isEqualTo((Object)CarrotAssertions.contentOfResource("/cn/boboweike/carrot/utils/mapper/enqueued-task-localdatetime-parameter.json"));
        Task actualTask = (Task)this.jsonMapper.deserialize(taskAsString, Task.class);
        CarrotAssertions.assertThat(actualTask).isEqualTo(task);
    }

    @Test
    void testSerializeAndDeserializeEnqueuedTaskWithPathTaskParameter() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> this.testService.doWorkWithPath(Paths.get("/tmp", "carrot", "file.xml"))).build();
        String taskAsString = this.jsonMapper.serialize((Object)task);
        CarrotAssertions.assertThatJson(taskAsString).isEqualTo((Object)CarrotAssertions.contentOfResource("/cn/boboweike/carrot/utils/mapper/enqueued-task-path-parameter.json"));
        Task actualTask = (Task)this.jsonMapper.deserialize(taskAsString, Task.class);
        CarrotAssertions.assertThat(actualTask).isEqualTo(task);
    }

    @Test
    void testSerializeAndDeserializeEnqueuedTaskWithInterfaceAsTaskParameter() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> this.testService.doWorkWithCommand(new TestService.SimpleCommand("Hello", 5))).build();
        String taskAsString = this.jsonMapper.serialize((Object)task);
        CarrotAssertions.assertThatJson(taskAsString).isEqualTo((Object)CarrotAssertions.contentOfResource("/cn/boboweike/carrot/utils/mapper/enqueued-task-interface-object-parameter.json"));
        Task actualTask = (Task)this.jsonMapper.deserialize(taskAsString, Task.class);
        CarrotAssertions.assertThat(actualTask).isEqualTo(task);
    }

    @Test
    void testSerializeAndDeserializeSucceededTask() {
        Task task = TaskTestBuilder.aSucceededTask().build();
        String taskAsString = this.jsonMapper.serialize((Object)task);
        CarrotAssertions.assertThatJson(taskAsString).isEqualTo((Object)CarrotAssertions.contentOfResource("/cn/boboweike/carrot/utils/mapper/succeeded-task.json"));
        Task actualTask = (Task)this.jsonMapper.deserialize(taskAsString, Task.class);
        CarrotAssertions.assertThat(actualTask).isEqualTo(task);
    }

    @Test
    void testSerializeAndDeserializeRecurringTask() {
        RecurringTask recurringTask = RecurringTaskTestBuilder.aDefaultRecurringTask().withName("some name").build();
        String recurringTaskAsString = this.jsonMapper.serialize((Object)recurringTask);
        CarrotAssertions.assertThatJson(recurringTaskAsString).isEqualTo((Object)CarrotAssertions.contentOfResource("/cn/boboweike/carrot/utils/mapper/recurring-task.json"));
        RecurringTask actualRecurringTask = (RecurringTask)this.jsonMapper.deserialize(recurringTaskAsString, RecurringTask.class);
        CarrotAssertions.assertThat(actualRecurringTask).isEqualTo(recurringTask);
    }

    @Test
    void testSerializeAndDeserializeEnqueuedTaskAfter4Dot0Dot0() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> this.testService.doWork(1L)).build();
        String taskAsString = this.jsonMapper.serialize((Object)task);
        CarrotAssertions.assertThatJson(taskAsString).isEqualTo((Object)CarrotAssertions.contentOfResource("/cn/boboweike/carrot/utils/mapper/enqueued-task-github-254.json"));
    }

    @Test
    void testSerializeAndDeserializeEnqueuedTaskComingFrom4Dot0Dot0() {
        Task task = TaskTestBuilder.aTask().withId(UUID.fromString("8bf98a10-f673-4fd8-9b9c-43ded0030910")).withName("an enqueued task").withState((TaskState)new EnqueuedState(), Instant.parse("2021-11-10T11:37:40.551537Z")).withTaskDetails((TaskLambda & Serializable)() -> this.testService.doWork(1L)).build();
        String taskAsString = this.jsonMapper.serialize((Object)task);
        CarrotAssertions.assertThatJson(taskAsString).isEqualTo((Object)CarrotAssertions.contentOfResource("/cn/boboweike/carrot/utils/mapper/enqueued-task-github-254.json"));
        Task actualTask = (Task)this.jsonMapper.deserialize(taskAsString, Task.class);
        CarrotAssertions.assertThat(actualTask).isEqualTo(task);
        String taskAsStringFrom4Dot0Dot0 = CarrotAssertions.contentOfResource("/cn/boboweike/carrot/utils/mapper/enqueued-task-github-254-input.json");
        Task actualTaskFrom4Dot0Dot0 = (Task)this.jsonMapper.deserialize(taskAsStringFrom4Dot0Dot0, Task.class);
        CarrotAssertions.assertThat(actualTaskFrom4Dot0Dot0).isEqualTo(task);
    }

    @Test
    void testCanSerializeCollections() {
        Long value = 1L;
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> this.testService.doWorkWithCollection(Collections.singleton(value))).build();
        String taskAsString = this.jsonMapper.serialize((Object)task);
        Task deserializedTask = (Task)this.jsonMapper.deserialize(taskAsString, Task.class);
        CarrotAssertions.assertThat(deserializedTask.getTaskDetails()).hasArgs(Collections.singleton(value));
    }

    @Test
    void testCanSerializeEnums() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> this.testService.doWorkWithEnum(TestService.Task.PROGRAMMING)).build();
        String taskAsString = this.jsonMapper.serialize((Object)task);
        Task deserializedTask = (Task)this.jsonMapper.deserialize(taskAsString, Task.class);
        CarrotAssertions.assertThat(deserializedTask.getTaskDetails()).hasArgs(new Object[]{TestService.Task.PROGRAMMING});
    }
}

