/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils.mapper;

import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import cn.boboweike.carrot.utils.mapper.AbstractJsonMapperTest;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.TaskParameterJsonMapperException;
import cn.boboweike.carrot.utils.mapper.jackson.JacksonJsonMapper;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import java.io.Serializable;
import java.util.Objects;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class JacksonUsingCarrotTimeModuleJsonMapperTest
extends AbstractJsonMapperTest {
    @Override
    public JsonMapper newJsonMapper() {
        return new JacksonJsonMapper(false);
    }

    @Override
    @Test
    void testSerializeAndDeserializeEnqueuedTaskWithLocalDateTimeTaskParameter() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> super.testSerializeAndDeserializeEnqueuedTaskWithLocalDateTimeTaskParameter()).isInstanceOf(TaskParameterJsonMapperException.class)).hasCauseInstanceOf(InvalidDefinitionException.class);
    }

    @Test
    void testCanDeserializeWithJsonCreator() {
        SomeParameter someParameter = new SomeParameter(3);
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> this.doWorkWithParameter(someParameter)).build();
        String taskAsString = this.jsonMapper.serialize((Object)task);
        Task deserializedTask = (Task)this.jsonMapper.deserialize(taskAsString, Task.class);
        CarrotAssertions.assertThat(deserializedTask.getTaskDetails()).hasArgs(someParameter);
    }

    public void doWorkWithParameter(SomeParameter parameter) {
        System.out.println(parameter);
    }

    public static class SomeParameter {
        private final int value;

        @JsonCreator
        public SomeParameter(@JsonProperty(value="value") int value) {
            this.value = value;
        }

        public String toString() {
            return "Some Parameter " + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SomeParameter that = (SomeParameter)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

