/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils.reflection;

import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.sql.Clob;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ReflectionUtilsTest {
    ReflectionUtilsTest() {
    }

    @Test
    void testToClass() {
        Assertions.assertThat((Class)ReflectionUtils.toClass((String)"boolean")).isEqualTo(Boolean.TYPE);
        Assertions.assertThat((Class)ReflectionUtils.toClass((String)"byte")).isEqualTo(Byte.TYPE);
        Assertions.assertThat((Class)ReflectionUtils.toClass((String)"short")).isEqualTo(Short.TYPE);
        Assertions.assertThat((Class)ReflectionUtils.toClass((String)"int")).isEqualTo(Integer.TYPE);
        Assertions.assertThat((Class)ReflectionUtils.toClass((String)"long")).isEqualTo(Long.TYPE);
        Assertions.assertThat((Class)ReflectionUtils.toClass((String)"float")).isEqualTo(Float.TYPE);
        Assertions.assertThat((Class)ReflectionUtils.toClass((String)"double")).isEqualTo(Double.TYPE);
        Assertions.assertThat((Class)ReflectionUtils.toClass((String)"char")).isEqualTo(Character.TYPE);
        Assertions.assertThat((Class)ReflectionUtils.toClass((String)"void")).isEqualTo(Void.TYPE);
        Assertions.assertThat((Class)ReflectionUtils.toClass((String)"java.lang.String")).isEqualTo(String.class);
        Assertions.assertThatThrownBy(() -> ReflectionUtils.toClass((String)"class.that.does.not.exist")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testObjectContainsFieldOrProperty() {
        TestObject test = new TestObject("test");
        Assertions.assertThat((boolean)ReflectionUtils.objectContainsFieldOrProperty((Object)test, (String)"field")).isTrue();
        Assertions.assertThat((boolean)ReflectionUtils.objectContainsFieldOrProperty((Object)test, (String)"anotherField")).isTrue();
        Assertions.assertThat((boolean)ReflectionUtils.objectContainsFieldOrProperty((Object)test, (String)"doesNotExist")).isFalse();
    }

    @Test
    void testGetValueFromFieldOrProperty() {
        TestObject test = new TestObject("test");
        Assertions.assertThat((Object)ReflectionUtils.getValueFromFieldOrProperty((Object)test, (String)"field")).isEqualTo((Object)"test");
        Assertions.assertThat((Object)ReflectionUtils.getValueFromFieldOrProperty((Object)test, (String)"anotherField")).isEqualTo((Object)"test");
        Assertions.assertThatThrownBy(() -> ReflectionUtils.getValueFromFieldOrProperty((Object)test, (String)"doesNotExist")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testAutobox() {
        Assertions.assertThat((String)((String)ReflectionUtils.autobox(null, String.class))).isEqualTo(null);
        Assertions.assertThat((String)((String)ReflectionUtils.autobox((Object)"string", String.class))).isEqualTo("string");
        Assertions.assertThat((Integer)((Integer)ReflectionUtils.autobox((Object)1, Integer.TYPE))).isEqualTo(1);
        Assertions.assertThat((Integer)((Integer)ReflectionUtils.autobox((Object)1, Integer.class))).isEqualTo(1);
        Assertions.assertThat((Integer)((Integer)ReflectionUtils.autobox((Object)"1", Integer.TYPE))).isEqualTo(1);
        Assertions.assertThat((Integer)((Integer)ReflectionUtils.autobox((Object)"1", Integer.class))).isEqualTo(1);
        Assertions.assertThat((Long)((Long)ReflectionUtils.autobox((Object)1L, Long.TYPE))).isEqualTo(1L);
        Assertions.assertThat((Long)((Long)ReflectionUtils.autobox((Object)1, Long.class))).isEqualTo(1L);
        Assertions.assertThat((Long)((Long)ReflectionUtils.autobox((Object)"1", Long.TYPE))).isEqualTo(1L);
        Assertions.assertThat((Long)((Long)ReflectionUtils.autobox((Object)"1", Long.class))).isEqualTo(1L);
        Assertions.assertThat((Comparable)((UUID)ReflectionUtils.autobox((Object)"6ec8044c-ad95-4416-a29e-e946c72a37b0", UUID.class))).isEqualTo((Object)UUID.fromString("6ec8044c-ad95-4416-a29e-e946c72a37b0"));
        Assertions.assertThat((Comparable)((Object)((TestEnum)((Object)ReflectionUtils.autobox((Object)"A", TestEnum.class))))).isEqualTo((Object)TestEnum.A);
        Assertions.assertThat((Duration)((Duration)ReflectionUtils.autobox((Object)"PT8H6M12.345S", Duration.class))).isEqualTo((Object)Duration.parse("PT8H6M12.345S"));
    }

    @Test
    void testAutoboxClob() throws SQLException {
        Clob clob = (Clob)Mockito.mock(Clob.class);
        String result = "the result";
        Mockito.when((Object)clob.length()).thenReturn((Object)result.length());
        Mockito.when((Object)clob.getSubString(1L, result.length())).thenReturn((Object)result);
        Assertions.assertThat((String)((String)ReflectionUtils.autobox((Object)clob, String.class))).isEqualTo(result);
    }

    @Test
    void testFindMethodOnInterface() {
        Optional doWork = ReflectionUtils.findMethod(TestInterface.class, (String)"doWork", (Class[])new Class[0]);
        Assertions.assertThat((Optional)doWork).isPresent();
    }

    @Test
    void testFindMethodOnSuperInterface() {
        Optional doWorkFromParentInterfaceA = ReflectionUtils.findMethod(TestInterface.class, (String)"doWorkFromParentInterfaceA", (Class[])new Class[0]);
        Assertions.assertThat((Optional)doWorkFromParentInterfaceA).isPresent();
        Optional doWorkFromParentInterfaceB = ReflectionUtils.findMethod(TestInterface.class, (String)"doWorkFromParentInterfaceB", (Class[])new Class[0]);
        Assertions.assertThat((Optional)doWorkFromParentInterfaceB).isPresent();
    }

    public static interface TestInterfaceParentB {
        public void doWorkFromParentInterfaceB();
    }

    public static interface TestInterfaceParentA {
        public void doWorkFromParentInterfaceA();
    }

    public static interface TestInterface
    extends TestInterfaceParentA,
    TestInterfaceParentB {
        public void doWork();
    }

    public static enum TestEnum {
        A,
        B;

    }

    public static class TestObject {
        private final String field;

        public TestObject(String field) {
            this.field = field;
        }

        public String getAnotherField() {
            return this.field;
        }
    }
}

