/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils.resilience;

import cn.boboweike.carrot.utils.resilience.RateLimiter;
import java.time.Duration;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

class RateLimiterTest {
    RateLimiterTest() {
    }

    @Test
    void testRateLimit() {
        RateLimiter rateLimit = RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND);
        Awaitility.await().pollInterval(Duration.ofMillis(20L)).atMost(Duration.ofMillis(150L)).untilAsserted(() -> {
            Assertions.assertThat((boolean)rateLimit.isAllowed()).isTrue();
            Assertions.assertThat((boolean)rateLimit.isAllowed()).isFalse();
        });
        Awaitility.await().pollInterval(Duration.ofMillis(20L)).atMost(Duration.ofMillis(1050L)).untilAsserted(() -> Assertions.assertThat((boolean)rateLimit.isAllowed()).isTrue());
    }

    @Test
    void testRateLimit8PerSecond() {
        RateLimiter rateLimit = RateLimiter.Builder.rateLimit().atRequests(8).per(RateLimiter.SECOND);
        ArrayList allowed = new ArrayList();
        Awaitility.await().pollInterval(Duration.ofMillis(20L)).atMost(Duration.ofMillis(1050L)).untilAsserted(() -> {
            allowed.add(rateLimit.isAllowed());
            Assertions.assertThat(allowed.stream().filter(x -> x)).hasSize(8);
        });
    }
}

