/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils.resources;

import cn.boboweike.carrot.utils.resources.ClassPathResourceProvider;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClassPathResourceProviderTest {
    @Test
    void canListChildren() {
        try (ClassPathResourceProvider resourceProvider = new ClassPathResourceProvider();){
            Stream<String> folderItems = resourceProvider.listAllChildrenOnClasspath(ClassPathResourceProviderTest.class, new String[]{"somefolder"}).map(path -> path.getFileName().toString());
            Assertions.assertThat(folderItems).contains((Object[])new String[]{"file1.txt", "file2.txt"});
        }
    }

    @Test
    void canListChildrenInJar() {
        try (ClassPathResourceProvider resourceProvider = new ClassPathResourceProvider();){
            Stream<String> folderItems = resourceProvider.listAllChildrenOnClasspath(Test.class, new String[0]).map(path -> path.getFileName().toString());
            Assertions.assertThat(folderItems).contains((Object[])new String[]{"Test.class", "Tags.class"});
        }
    }

    @Test
    void classPathResourceProviderIsThreadsafe() throws InterruptedException {
        AtomicInteger atomicInteger = new AtomicInteger();
        CountDownLatch countDownLatch = new CountDownLatch(3);
        Thread thread1 = new Thread(() -> this.useClassPathResourceProvider(atomicInteger, countDownLatch));
        Thread thread2 = new Thread(() -> this.useClassPathResourceProvider(atomicInteger, countDownLatch));
        Thread thread3 = new Thread(() -> this.useClassPathResourceProvider(atomicInteger, countDownLatch));
        thread1.start();
        thread2.start();
        thread3.start();
        countDownLatch.await(10L, TimeUnit.SECONDS);
        Assertions.assertThat((int)atomicInteger.get()).isEqualTo(300);
    }

    private void useClassPathResourceProvider(AtomicInteger atomicInteger, CountDownLatch countDownLatch) {
        for (int i = 0; i < 100; ++i) {
            try (ClassPathResourceProvider resourceProvider = new ClassPathResourceProvider();){
                Stream<String> folderItems = resourceProvider.listAllChildrenOnClasspath(Test.class, new String[0]).map(path -> path.getFileName().toString());
                Assertions.assertThat(folderItems).contains((Object[])new String[]{"Test.class", "Tags.class"});
                atomicInteger.incrementAndGet();
                continue;
            }
        }
        countDownLatch.countDown();
    }
}

