/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.db.DatabaseQueries;
import org.assertj.db.DatabaseQueriesByProvider;

public class DatabaseAssertions
extends AbstractAssert<DatabaseAssertions, DataSource> {
    private List<String> tablenames;
    private List<String> indices;
    private List<String> views;

    private DatabaseAssertions(DataSource dataSource) {
        super((Object)dataSource, DatabaseAssertions.class);
    }

    public static DatabaseAssertions assertThat(DataSource dataSource) {
        return new DatabaseAssertions(dataSource);
    }

    public DatabaseAssertions hasTable(String tableName) {
        Assertions.assertThat(this.allTables()).anyMatch(someTableName -> someTableName.toUpperCase().contains(tableName.toUpperCase()));
        return this;
    }

    public DatabaseAssertions hasTable(String schema, String tableName) {
        Assertions.assertThat(this.allTables()).contains((Object[])new String[]{(schema + "." + tableName).toUpperCase()});
        return this;
    }

    public DatabaseAssertions hasView(String viewName) {
        Assertions.assertThat(this.allViews()).anyMatch(someTableName -> someTableName.toUpperCase().contains(viewName.toUpperCase()));
        return this;
    }

    public DatabaseAssertions hasView(String schema, String viewName) {
        Assertions.assertThat(this.allViews()).contains((Object[])new String[]{(schema + "." + viewName).toUpperCase()});
        return this;
    }

    public DatabaseAssertions hasIndex(String schema, String tableName) {
        Assertions.assertThat(this.allIndices()).contains((Object[])new String[]{(schema + "." + tableName).toUpperCase()});
        return this;
    }

    public DatabaseAssertions hasIndexesMatching(int times, Condition<String> condition) {
        Assertions.assertThat(this.allIndices()).areAtLeast(times, condition);
        return this;
    }

    public DatabaseAssertions hasIndex(Predicate<String> predicate) {
        Assertions.assertThat(this.allIndices()).anyMatch(predicate);
        return this;
    }

    private List<String> allTables() {
        if (this.tablenames == null) {
            try (Connection connection = ((DataSource)this.actual).getConnection();
                 Statement statement = connection.createStatement();){
                DatabaseQueries databaseQueries = this.getDatabaseQueries(connection);
                try (ResultSet rs = statement.executeQuery(databaseQueries.getAllTablesQuery());){
                    this.tablenames = new ArrayList<String>();
                    while (rs.next()) {
                        String tableSchema = rs.getString("table_schema");
                        String tableName = rs.getString("table_name");
                        this.tablenames.add((tableSchema + "." + tableName).toUpperCase());
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.tablenames;
    }

    private List<String> allIndices() {
        if (this.indices == null) {
            try (Connection connection = ((DataSource)this.actual).getConnection();
                 Statement statement = connection.createStatement();){
                DatabaseQueries databaseQueries = this.getDatabaseQueries(connection);
                try (ResultSet rs = statement.executeQuery(databaseQueries.getAllIndicesQuery());){
                    this.indices = new ArrayList<String>();
                    while (rs.next()) {
                        this.indices.add(rs.getString("index_name").toUpperCase());
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.indices;
    }

    private List<String> allViews() {
        if (this.views == null) {
            try (Connection connection = ((DataSource)this.actual).getConnection();
                 Statement statement = connection.createStatement();){
                DatabaseQueries databaseQueries = this.getDatabaseQueries(connection);
                try (ResultSet rs = statement.executeQuery(databaseQueries.getAllViewsQuery());){
                    this.views = new ArrayList<String>();
                    while (rs.next()) {
                        this.views.add(rs.getString("view_name").toUpperCase());
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.views;
    }

    private DatabaseQueries getDatabaseQueries(Connection connection) throws SQLException {
        String databaseName = connection.getMetaData().getDatabaseProductName();
        return DatabaseQueriesByProvider.getFor(databaseName);
    }
}

