/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db;

import java.util.HashMap;
import java.util.Map;
import org.assertj.db.DatabaseQueries;
import org.assertj.db.H2DatabaseQueries;
import org.assertj.db.PostgresDatabaseQueries;

public class DatabaseQueriesByProvider {
    private static Map<String, DatabaseQueries> databaseQueryMap = new HashMap<String, DatabaseQueries>();

    public static DatabaseQueries getFor(String provider) {
        return databaseQueryMap.getOrDefault(provider, new PostgresDatabaseQueries());
    }

    static {
        databaseQueryMap.put("PostgreSQL", new PostgresDatabaseQueries());
        databaseQueryMap.put("H2", new H2DatabaseQueries());
        databaseQueryMap.put("HSQL Database Engine", new H2DatabaseQueries());
    }
}

