/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot;

public class CarrotException
extends RuntimeException {
    public static final String SHOULD_NOT_HAPPEN_MESSAGE = "Carrot encountered a problematic exception. Please create a bug report (if possible, provide the code to reproduce this and the stacktrace)";
    public static final String INVALID_LAMBDA_MESSAGE = "The lambda you provided is not valid.";
    private final boolean doNotRetry;

    public CarrotException(String message) {
        this(message, false);
    }

    public CarrotException(String message, Throwable cause) {
        this(message, false, cause);
    }

    public CarrotException(String message, boolean doNotRetry) {
        super(message);
        this.doNotRetry = doNotRetry;
    }

    public CarrotException(String message, boolean doNotRetry, Throwable cause) {
        super(message, cause);
        this.doNotRetry = doNotRetry;
    }

    public boolean isProblematicAndDoNotRetry() {
        return this.doNotRetry;
    }

    public static CarrotException shouldNotHappenException(String message) {
        return new CarrotException(SHOULD_NOT_HAPPEN_MESSAGE, new IllegalStateException(message));
    }

    public static CarrotException invalidLambdaException(Exception exception) {
        return new CarrotException(INVALID_LAMBDA_MESSAGE, exception);
    }

    public static CarrotException shouldNotHappenException(Throwable cause) {
        if (cause instanceof CarrotException) {
            return (CarrotException)cause;
        }
        if (cause.getCause() instanceof CarrotException) {
            return (CarrotException)cause.getCause();
        }
        return new CarrotException(SHOULD_NOT_HAPPEN_MESSAGE, cause);
    }

    public static CarrotException configurationException(String message) {
        return new CarrotException(message);
    }

    public static CarrotException problematicConfigurationException(String message) {
        return new CarrotException(message, true);
    }

    public static CarrotException problematicException(String message, Throwable cause) {
        return new CarrotException(message, true, cause);
    }

    public static CarrotException configurationException(String message, Throwable cause) {
        if (cause instanceof CarrotException) {
            return (CarrotException)cause;
        }
        if (cause.getCause() instanceof CarrotException) {
            return (CarrotException)cause.getCause();
        }
        return new CarrotException(message, cause);
    }
}

