/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.configuration;

import cn.boboweike.carrot.configuration.CarrotConfiguration;
import cn.boboweike.carrot.server.BackgroundTaskServer;

public class Carrot {
    private static CarrotConfiguration carrotConfiguration;

    private Carrot() {
    }

    public static CarrotConfiguration configure() {
        carrotConfiguration = new CarrotConfiguration();
        Runtime.getRuntime().addShutdownHook(new Thread(Carrot::destroy, "extShutdownHook"));
        return carrotConfiguration;
    }

    public static CarrotConfiguration destroy() {
        if (carrotConfiguration != null) {
            if (Carrot.carrotConfiguration.backgroundTaskServer != null) {
                Carrot.carrotConfiguration.backgroundTaskServer.stop();
            }
            if (Carrot.carrotConfiguration.dashboardWebServer != null) {
                Carrot.carrotConfiguration.dashboardWebServer.stop();
            }
            if (Carrot.carrotConfiguration.storageProvider != null) {
                Carrot.carrotConfiguration.storageProvider.close();
            }
            if (Carrot.carrotConfiguration.microMeterIntegration != null) {
                Carrot.carrotConfiguration.microMeterIntegration.close();
            }
        }
        return carrotConfiguration;
    }

    public static BackgroundTaskServer getBackgroundTaskServer() {
        if (carrotConfiguration == null) {
            throw new IllegalStateException("You don't seem to use the Fluent API. This method is only available if you are using the Fluent API to configure Carrot");
        }
        if (Carrot.carrotConfiguration.backgroundTaskServer == null) {
            throw new IllegalStateException("The background task server is not configured. Are you perhaps only running the TaskScheduler or the Dashboard on this server instance?");
        }
        return Carrot.carrotConfiguration.backgroundTaskServer;
    }
}

