/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.configuration;

import cn.boboweike.carrot.configuration.CarrotMicroMeterIntegration;
import cn.boboweike.carrot.dashboard.CarrotDashboardWebServer;
import cn.boboweike.carrot.dashboard.CarrotDashboardWebServerConfiguration;
import cn.boboweike.carrot.scheduling.TaskRequestScheduler;
import cn.boboweike.carrot.scheduling.TaskScheduler;
import cn.boboweike.carrot.scheduling.partition.Partitioner;
import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.server.BackgroundTaskServerConfiguration;
import cn.boboweike.carrot.server.TaskActivator;
import cn.boboweike.carrot.server.jmx.CarrotJMXExtensions;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.details.CachingTaskDetailsGenerator;
import cn.boboweike.carrot.tasks.details.TaskDetailsGenerator;
import cn.boboweike.carrot.tasks.filters.TaskFilter;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.JsonMapperException;
import cn.boboweike.carrot.utils.mapper.JsonMapperValidator;
import cn.boboweike.carrot.utils.mapper.gson.GsonJsonMapper;
import cn.boboweike.carrot.utils.mapper.jackson.JacksonJsonMapper;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class CarrotConfiguration {
    TaskActivator taskActivator;
    JsonMapper jsonMapper = CarrotConfiguration.determineJsonMapper();
    TaskMapper taskMapper = new TaskMapper(this.jsonMapper);
    final List<TaskFilter> taskFilters;
    TaskDetailsGenerator taskDetailsGenerator = new CachingTaskDetailsGenerator();
    PartitionedStorageProvider storageProvider;
    BackgroundTaskServer backgroundTaskServer;
    CarrotDashboardWebServer dashboardWebServer;
    CarrotJMXExtensions jmxExtension;
    CarrotMicroMeterIntegration microMeterIntegration;

    CarrotConfiguration() {
        this.taskFilters = new ArrayList<TaskFilter>();
    }

    public CarrotConfiguration useJsonMapper(JsonMapper jsonMapper) {
        if (this.storageProvider != null) {
            throw new IllegalStateException("Please configure the TaskActivator before the StorageProvider.");
        }
        if (this.dashboardWebServer != null) {
            throw new IllegalStateException("Please configure the TaskActivator before the DashboardWebServer.");
        }
        this.jsonMapper = JsonMapperValidator.validateJsonMapper(jsonMapper);
        this.taskMapper = new TaskMapper(jsonMapper);
        return this;
    }

    public CarrotConfiguration useTaskActivator(TaskActivator taskActivator) {
        if (this.backgroundTaskServer != null) {
            throw new IllegalStateException("Please configure the TaskActivator before the BackgroundTaskServer.");
        }
        this.taskActivator = taskActivator;
        return this;
    }

    public CarrotConfiguration useStorageProvider(PartitionedStorageProvider storageProvider) {
        this.storageProvider = storageProvider;
        storageProvider.setTaskMapper(this.taskMapper);
        return this;
    }

    public CarrotConfiguration usePartitioner(Partitioner partitioner) {
        if (this.storageProvider == null) {
            throw new IllegalStateException("Please configure the PartitionedStorageProvider before the Partitioner.");
        }
        this.storageProvider.setPartitioner(partitioner);
        return this;
    }

    public CarrotConfiguration withTaskFilter(TaskFilter ... taskFilters) {
        if (this.backgroundTaskServer != null) {
            throw new IllegalStateException("Please configure the TaskFilters before the BackgroundTaskServer.");
        }
        this.taskFilters.addAll(Arrays.asList(taskFilters));
        return this;
    }

    public CarrotConfiguration useBackgroundTaskServer() {
        return this.useBackgroundTaskServerIf(true);
    }

    public CarrotConfiguration useBackgroundTaskServerIf(boolean guard) {
        return this.useBackgroundTaskServerIf(guard, BackgroundTaskServerConfiguration.usingStandardBackgroundTaskServerConfiguration());
    }

    public CarrotConfiguration useBackgroundTaskServer(int workerCount) {
        return this.useBackgroundTaskServerIf(true, workerCount);
    }

    public CarrotConfiguration useBackgroundTaskServerIf(boolean guard, int workerCount) {
        return this.useBackgroundTaskServerIf(guard, BackgroundTaskServerConfiguration.usingStandardBackgroundTaskServerConfiguration().andWorkerCount(workerCount));
    }

    public CarrotConfiguration useBackgroundTaskServer(BackgroundTaskServerConfiguration configuration) {
        return this.useBackgroundTaskServerIf(true, configuration);
    }

    public CarrotConfiguration useBackgroundTaskServer(BackgroundTaskServerConfiguration configuration, boolean startBackgroundTaskServer) {
        return this.useBackgroundTaskServerIf(true, configuration, startBackgroundTaskServer);
    }

    public CarrotConfiguration useBackgroundTaskServerIf(boolean guard, BackgroundTaskServerConfiguration configuration) {
        return this.useBackgroundTaskServerIf(guard, configuration, true);
    }

    public CarrotConfiguration useBackgroundTaskServerIf(boolean guard, BackgroundTaskServerConfiguration configuration, boolean startBackgroundTaskServer) {
        if (guard) {
            this.backgroundTaskServer = new BackgroundTaskServer(this.storageProvider, this.taskActivator, configuration);
            this.backgroundTaskServer.setTaskFilters(this.taskFilters);
            this.backgroundTaskServer.start(startBackgroundTaskServer);
        }
        return this;
    }

    public CarrotConfiguration useDashboard() {
        return this.useDashboardIf(true);
    }

    public CarrotConfiguration useDashboardIf(boolean guard) {
        return this.useDashboardIf(guard, CarrotDashboardWebServerConfiguration.usingStandardDashboardConfiguration());
    }

    public CarrotConfiguration useDashboard(int dashboardPort) {
        return this.useDashboardIf(true, dashboardPort);
    }

    public CarrotConfiguration useDashboardIf(boolean guard, int dashboardPort) {
        return this.useDashboardIf(guard, CarrotDashboardWebServerConfiguration.usingStandardDashboardConfiguration().andPort(dashboardPort));
    }

    public CarrotConfiguration useDashboard(CarrotDashboardWebServerConfiguration configuration) {
        return this.useDashboardIf(true, configuration);
    }

    public CarrotConfiguration useDashboardIf(boolean guard, CarrotDashboardWebServerConfiguration configuration) {
        if (guard) {
            this.dashboardWebServer = new CarrotDashboardWebServer(this.storageProvider, this.jsonMapper, configuration);
            this.dashboardWebServer.start();
        }
        return this;
    }

    public CarrotConfiguration useJmxExtensions() {
        return this.useJmxExtensionsIf(true);
    }

    public CarrotConfiguration useJmxExtensionsIf(boolean guard) {
        if (guard) {
            if (this.backgroundTaskServer == null) {
                throw new IllegalStateException("Please configure the BackgroundTaskServer before the JMXExtension.");
            }
            if (this.storageProvider == null) {
                throw new IllegalStateException("Please configure the StorageProvider before the JMXExtension.");
            }
            this.jmxExtension = new CarrotJMXExtensions(this.backgroundTaskServer, this.storageProvider);
        }
        return this;
    }

    public CarrotConfiguration useMicroMeter(CarrotMicroMeterIntegration microMeterIntegration) {
        this.microMeterIntegration = microMeterIntegration;
        return this;
    }

    public CarrotConfiguration useTaskDetailsGenerator(TaskDetailsGenerator taskDetailsGenerator) {
        this.taskDetailsGenerator = taskDetailsGenerator;
        return this;
    }

    public CarrotConfigurationResult initialize() {
        Optional.ofNullable(this.microMeterIntegration).ifPresent(meterRegistry -> meterRegistry.initialize(this.storageProvider, this.backgroundTaskServer));
        TaskScheduler taskScheduler = new TaskScheduler(this.storageProvider, this.taskDetailsGenerator, this.taskFilters);
        TaskRequestScheduler taskRequestScheduler = new TaskRequestScheduler(this.storageProvider, this.taskFilters);
        return new CarrotConfigurationResult(taskScheduler, taskRequestScheduler);
    }

    private static JsonMapper determineJsonMapper() {
        if (ReflectionUtils.classExists("com.fasterxml.jackson.databind.ObjectMapper")) {
            return new JacksonJsonMapper();
        }
        if (ReflectionUtils.classExists("com.google.gson.Gson")) {
            return new GsonJsonMapper();
        }
        throw new JsonMapperException("No JsonMapper class is found. Make sure you have either Jackson compliant library available on your classpath");
    }

    public static class CarrotConfigurationResult {
        private final TaskScheduler taskScheduler;
        private final TaskRequestScheduler taskRequestScheduler;

        public CarrotConfigurationResult(TaskScheduler taskScheduler, TaskRequestScheduler taskRequestScheduler) {
            this.taskScheduler = taskScheduler;
            this.taskRequestScheduler = taskRequestScheduler;
        }

        public TaskScheduler getTaskScheduler() {
            return this.taskScheduler;
        }

        public TaskRequestScheduler getTaskRequestScheduler() {
            return this.taskRequestScheduler;
        }
    }
}

