/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.configuration;

import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.server.metrics.BackgroundTaskServerMetricsBinder;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.metrics.StorageProviderMetricsBinder;
import io.micrometer.core.instrument.MeterRegistry;

public class CarrotMicroMeterIntegration
implements AutoCloseable {
    private final MeterRegistry meterRegistry;
    private StorageProviderMetricsBinder storageProviderMetricsBinder;
    private BackgroundTaskServerMetricsBinder backgroundTaskServerMetricsBinder;

    public CarrotMicroMeterIntegration(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void initialize(PartitionedStorageProvider storageProvider, BackgroundTaskServer backgroundTaskServer) {
        this.storageProviderMetricsBinder = new StorageProviderMetricsBinder(storageProvider, this.meterRegistry);
        if (backgroundTaskServer != null) {
            this.backgroundTaskServerMetricsBinder = new BackgroundTaskServerMetricsBinder(backgroundTaskServer, this.meterRegistry);
        }
    }

    @Override
    public void close() {
        this.storageProviderMetricsBinder.close();
        if (this.backgroundTaskServerMetricsBinder != null) {
            this.backgroundTaskServerMetricsBinder.close();
        }
    }
}

