/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard;

import cn.boboweike.carrot.dashboard.server.http.RestHttpHandler;
import cn.boboweike.carrot.dashboard.server.http.handlers.HttpRequestHandler;
import cn.boboweike.carrot.dashboard.ui.model.RecurringTaskUIModel;
import cn.boboweike.carrot.dashboard.ui.model.VersionUIModel;
import cn.boboweike.carrot.dashboard.ui.model.problems.ProblemsManager;
import cn.boboweike.carrot.storage.PageRequest;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.TaskNotFoundException;
import cn.boboweike.carrot.tasks.RecurringTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class CarrotApiHandler
extends RestHttpHandler {
    private final PartitionedStorageProvider storageProvider;
    private final ProblemsManager problemsManager;
    private VersionUIModel versionUIModel;

    public CarrotApiHandler(PartitionedStorageProvider storageProvider, JsonMapper jsonMapper) {
        super("/api", jsonMapper);
        this.storageProvider = storageProvider;
        this.problemsManager = new ProblemsManager(storageProvider);
        this.get("/tasks", this.findTaskByState());
        this.get("/tasks/:id", this.getTaskById());
        this.delete("/tasks/:id", this.deleteTaskById());
        this.post("/tasks/:id/requeue", this.requeueTaskById());
        this.get("/problems", this.getProblems());
        this.delete("/problems/:type", this.deleteProblemByType());
        this.get("/recurring-tasks", this.getRecurringTasks());
        this.delete("/recurring-tasks/:id", this.deleteRecurringTask());
        this.post("/recurring-tasks/:id/trigger", this.triggerRecurringTask());
        this.get("/servers", this.getBackgroundTaskServers());
        this.get("/partition-number", this.getNumberOfPartitions());
        this.get("/version", this.getVersion());
        this.withExceptionMapping(TaskNotFoundException.class, (exc, resp) -> resp.statusCode(404));
    }

    private HttpRequestHandler getTaskById() {
        return (request, response) -> {
            UUID id = request.param(":id", UUID.class);
            response.asJson(this.storageProvider.getTaskById(id));
        };
    }

    private HttpRequestHandler deleteTaskById() {
        return (request, response) -> {
            UUID id = request.param(":id", UUID.class);
            Task task = this.storageProvider.getTaskById(id);
            task.delete("Task deleted via Dashboard");
            this.storageProvider.save(task);
            response.statusCode(204);
        };
    }

    private HttpRequestHandler requeueTaskById() {
        return (request, response) -> {
            UUID id = request.param(":id", UUID.class);
            Task task = this.storageProvider.getTaskById(id);
            task.enqueue();
            this.storageProvider.save(task);
            response.statusCode(204);
        };
    }

    private HttpRequestHandler findTaskByState() {
        return (request, response) -> {
            Integer partition = request.queryParam("partition", Integer.class, 0);
            StateName stateName = request.queryParam("state", StateName.class, StateName.ENQUEUED);
            response.asJson(this.storageProvider.getTaskPageByPartition(stateName, request.fromQueryParams(PageRequest.class), partition));
        };
    }

    private HttpRequestHandler getProblems() {
        return (request, response) -> response.asJson(this.problemsManager.getProblems());
    }

    private HttpRequestHandler deleteProblemByType() {
        return (request, response) -> {
            String type = request.param(":type", String.class);
            this.problemsManager.dismissProblemOfType(type);
            response.statusCode(204);
        };
    }

    private HttpRequestHandler getRecurringTasks() {
        return (request, response) -> {
            List recurringTaskUIModels = this.storageProvider.getRecurringTasks().stream().map(RecurringTaskUIModel::new).collect(Collectors.toList());
            response.asJson(recurringTaskUIModels);
        };
    }

    private HttpRequestHandler deleteRecurringTask() {
        return (request, response) -> {
            String id = request.param(":id");
            this.storageProvider.deleteRecurringTask(id);
            response.statusCode(204);
        };
    }

    private HttpRequestHandler triggerRecurringTask() {
        return (request, response) -> {
            String id = request.param(":id");
            RecurringTask recurringTask = this.storageProvider.getRecurringTasks().stream().filter(rt -> id.equals(rt.getId())).findFirst().orElseThrow(() -> new TaskNotFoundException(id));
            Task task = recurringTask.toEnqueuedTask();
            this.storageProvider.save(task);
            response.statusCode(204);
        };
    }

    private HttpRequestHandler getBackgroundTaskServers() {
        return (request, response) -> response.asJson(this.storageProvider.getBackgroundTaskServers());
    }

    private HttpRequestHandler getNumberOfPartitions() {
        NumberWrapper numberWrapper = new NumberWrapper();
        numberWrapper.number = this.storageProvider.getTotalNumOfPartitions();
        return (request, response) -> response.asJson(numberWrapper);
    }

    private HttpRequestHandler getVersion() {
        return (request, response) -> response.asJson(this.getVersionUIModel());
    }

    private VersionUIModel getVersionUIModel() {
        if (this.versionUIModel != null) {
            return this.versionUIModel;
        }
        this.versionUIModel = VersionUIModel.withoutAnonymousDataUsage();
        return this.versionUIModel;
    }

    static class NumberWrapper {
        public Integer number;

        NumberWrapper() {
        }
    }
}

