/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard;

import cn.boboweike.carrot.dashboard.CarrotApiHandler;
import cn.boboweike.carrot.dashboard.CarrotDashboardWebServerConfiguration;
import cn.boboweike.carrot.dashboard.CarrotSseHandler;
import cn.boboweike.carrot.dashboard.CarrotStaticFileHandler;
import cn.boboweike.carrot.dashboard.server.HttpExchangeHandler;
import cn.boboweike.carrot.dashboard.server.WebServer;
import cn.boboweike.carrot.dashboard.server.http.RedirectHttpHandler;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.ThreadSafePartitionedStorageProvider;
import cn.boboweike.carrot.utils.StringUtils;
import cn.boboweike.carrot.utils.annotations.VisibleFor;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.jackson.JacksonJsonMapper;
import com.sun.net.httpserver.BasicAuthenticator;
import com.sun.net.httpserver.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarrotDashboardWebServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CarrotDashboardWebServer.class);
    private final PartitionedStorageProvider storageProvider;
    private final JsonMapper jsonMapper;
    private final int port;
    private final BasicAuthenticator basicAuthenticator;
    private WebServer webServer;

    public static void main(String[] args) {
        new CarrotDashboardWebServer(null, new JacksonJsonMapper());
    }

    public CarrotDashboardWebServer(PartitionedStorageProvider storageProvider, JsonMapper jsonMapper) {
        this(storageProvider, jsonMapper, 8000);
    }

    public CarrotDashboardWebServer(PartitionedStorageProvider storageProvider, JsonMapper jsonMapper, int port) {
        this(storageProvider, jsonMapper, CarrotDashboardWebServerConfiguration.usingStandardDashboardConfiguration().andPort(port));
    }

    public CarrotDashboardWebServer(PartitionedStorageProvider storageProvider, JsonMapper jsonMapper, int port, String username, String password) {
        this(storageProvider, jsonMapper, CarrotDashboardWebServerConfiguration.usingStandardDashboardConfiguration().andPort(port).andBasicAuthentication(username, password));
    }

    public CarrotDashboardWebServer(PartitionedStorageProvider storageProvider, JsonMapper jsonMapper, CarrotDashboardWebServerConfiguration configuration) {
        if (storageProvider == null) {
            throw new IllegalArgumentException("A StorageProvider is required to use a CarrotDashboardWebServer. Please see the documentation on how to setup a task StorageProvider.");
        }
        this.storageProvider = new ThreadSafePartitionedStorageProvider(storageProvider);
        this.jsonMapper = jsonMapper;
        this.port = configuration.port;
        this.basicAuthenticator = this.createOptionalBasicAuthenticator(configuration.username, configuration.password);
    }

    public void start() {
        RedirectHttpHandler redirectHttpHandler = new RedirectHttpHandler("/", "/dashboard");
        CarrotStaticFileHandler staticFileHandler = this.createStaticFileHandler();
        CarrotApiHandler dashboardHandler = this.createApiHandler(this.storageProvider, this.jsonMapper);
        CarrotSseHandler sseHandler = this.createSSeHandler(this.storageProvider, this.jsonMapper);
        this.webServer = new WebServer(this.port);
        this.registerContext(redirectHttpHandler);
        this.registerSecuredContext(staticFileHandler);
        this.registerSecuredContext(dashboardHandler);
        this.registerSecuredContext(sseHandler);
        this.webServer.start();
        LOGGER.info("Carrot Dashboard using {} started at http://{}:{}/dashboard", new Object[]{this.storageProvider.getName(), this.webServer.getWebServerHostAddress(), this.webServer.getWebServerHostPort()});
    }

    public void stop() {
        if (this.webServer == null) {
            return;
        }
        this.webServer.stop();
        LOGGER.info("Carrot dashboard stopped");
        this.webServer = null;
    }

    HttpContext registerContext(HttpExchangeHandler httpHandler) {
        return this.webServer.createContext(httpHandler);
    }

    HttpContext registerSecuredContext(HttpExchangeHandler httpHandler) {
        HttpContext httpContext = this.registerContext(httpHandler);
        if (this.basicAuthenticator != null) {
            httpContext.setAuthenticator(this.basicAuthenticator);
        }
        return httpContext;
    }

    @VisibleFor(value="github issue 18")
    CarrotStaticFileHandler createStaticFileHandler() {
        return new CarrotStaticFileHandler();
    }

    @VisibleFor(value="github issue 18")
    CarrotApiHandler createApiHandler(PartitionedStorageProvider storageProvider, JsonMapper jsonMapper) {
        return new CarrotApiHandler(storageProvider, jsonMapper);
    }

    @VisibleFor(value="github issue 18")
    CarrotSseHandler createSSeHandler(PartitionedStorageProvider storageProvider, JsonMapper jsonMapper) {
        return new CarrotSseHandler(storageProvider, jsonMapper);
    }

    private BasicAuthenticator createOptionalBasicAuthenticator(final String username, final String password) {
        if (StringUtils.isNotNullOrEmpty(username) && StringUtils.isNotNullOrEmpty(password)) {
            return new BasicAuthenticator("Carrot"){

                @Override
                public boolean checkCredentials(String user, String pwd) {
                    return user.equals(username) && pwd.equals(password);
                }
            };
        }
        return null;
    }
}

