/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard.server;

import cn.boboweike.carrot.dashboard.server.HttpExchangeHandler;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebServer.class);
    private final HttpServer httpServer;
    private final ExecutorService executorService;
    private final Set<HttpExchangeHandler> httpHandlers;

    public WebServer(int port) {
        try {
            this.httpServer = HttpServer.create(new InetSocketAddress(port), 0);
            this.executorService = Executors.newCachedThreadPool();
            this.httpServer.setExecutor(this.executorService);
            this.httpHandlers = new HashSet<HttpExchangeHandler>();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public HttpContext createContext(HttpExchangeHandler httpHandler) {
        this.httpHandlers.add(httpHandler);
        return this.httpServer.createContext(httpHandler.getContextPath(), httpHandler);
    }

    public void start() {
        this.httpServer.start();
    }

    public void stop() {
        this.httpHandlers.forEach(this::closeHttpHandler);
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(2L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.httpServer.stop(0);
    }

    public String getWebServerHostAddress() {
        if (this.httpServer.getAddress().getAddress().isAnyLocalAddress()) {
            return "localhost";
        }
        return this.httpServer.getAddress().getAddress().getHostAddress();
    }

    public int getWebServerHostPort() {
        return this.httpServer.getAddress().getPort();
    }

    private void closeHttpHandler(HttpExchangeHandler httpHandler) {
        try {
            httpHandler.close();
        }
        catch (Exception shouldNotHappen) {
            LOGGER.warn("Error closing HttpHandler", (Throwable)shouldNotHappen);
        }
    }
}

