/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard.server.http;

import java.nio.file.Path;

public class ContentType {
    public static final String _HEADER_NAME = "content-type";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String TEXT_HTML = "text/html;charset=UTF-8";
    public static final String TEXT_PLAIN = "text/plain;charset=UTF-8";
    public static final String TEXT_JAVASCRIPT = "text/javascript;charset=UTF-8";
    public static final String TEXT_CSS = "text/css;charset=UTF-8";
    public static final String IMAGE_PNG = "image/png";
    public static final String IMAGE_X_ICON = "image/x-icon";

    private ContentType() {
    }

    public static String from(Path path) {
        return ContentType.from(path.toString());
    }

    public static String from(String path) {
        if (path.toLowerCase().endsWith(".html")) {
            return TEXT_HTML;
        }
        if (path.toLowerCase().endsWith(".txt")) {
            return TEXT_PLAIN;
        }
        if (path.toLowerCase().endsWith(".json")) {
            return APPLICATION_JSON;
        }
        if (path.toLowerCase().endsWith(".js")) {
            return TEXT_JAVASCRIPT;
        }
        if (path.toLowerCase().endsWith(".css")) {
            return TEXT_CSS;
        }
        if (path.toLowerCase().endsWith(".png")) {
            return IMAGE_PNG;
        }
        if (path.toLowerCase().endsWith(".ico")) {
            return IMAGE_X_ICON;
        }
        if (path.toLowerCase().endsWith(".map")) {
            return APPLICATION_OCTET_STREAM;
        }
        throw new IllegalArgumentException("Unsupported mimetype");
    }
}

