/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard.server.http;

import cn.boboweike.carrot.utils.mapper.JsonMapper;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.function.Consumer;

public class HttpResponse {
    private final HttpExchange httpExchange;
    private final JsonMapper jsonMapper;

    public HttpResponse(HttpExchange httpExchange, JsonMapper jsonMapper) {
        this.httpExchange = httpExchange;
        this.jsonMapper = jsonMapper;
    }

    public HttpResponse asJson(Object object) {
        return this.data("application/json", outputStream -> this.jsonMapper.serialize((OutputStream)outputStream, object));
    }

    public HttpResponse error(Throwable t) {
        this.data(500, "text/plain;charset=UTF-8", stream -> t.printStackTrace(new PrintStream((OutputStream)stream)));
        return this;
    }

    private HttpResponse data(String contentType, Consumer<OutputStream> streamConsumer) {
        this.data(200, contentType, streamConsumer);
        return this;
    }

    private HttpResponse data(int status, String contentType, Consumer<OutputStream> streamConsumer) {
        this.httpExchange.getResponseHeaders().add("content-type", contentType);
        this.httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        try (OutputStream outputStream = this.httpExchange.getResponseBody();){
            this.httpExchange.sendResponseHeaders(status, 0L);
            streamConsumer.accept(outputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public void statusCode(int i) {
        try {
            this.httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
            this.httpExchange.getResponseHeaders().add("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS");
            this.httpExchange.sendResponseHeaders(i, -1L);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

