/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard.server.http.handlers;

import cn.boboweike.carrot.dashboard.server.http.handlers.HttpRequestHandler;
import cn.boboweike.carrot.dashboard.server.http.handlers.HttpRequestMethodHandlers;
import java.util.HashMap;
import java.util.Map;

public class HttpRequestHandlers {
    public static final HttpRequestHandler ok = (httpRequest, httpResponse) -> httpResponse.statusCode(200);
    public static final HttpRequestHandler notFound = (httpRequest, httpResponse) -> httpResponse.statusCode(404);
    private final Map<String, HttpRequestMethodHandlers> requestHandlers = new HashMap<String, HttpRequestMethodHandlers>();

    public void get(String url, HttpRequestHandler httpRequestHandler) {
        this.getAllRequestMethodHandlers("GET").put(url, httpRequestHandler);
    }

    public void put(String url, HttpRequestHandler httpRequestHandler) {
        this.getAllRequestMethodHandlers("PUT").put(url, httpRequestHandler);
    }

    public void post(String url, HttpRequestHandler httpRequestHandler) {
        this.getAllRequestMethodHandlers("POST").put(url, httpRequestHandler);
    }

    public void delete(String url, HttpRequestHandler httpRequestHandler) {
        this.getAllRequestMethodHandlers("OPTIONS").put(url, ok);
        this.getAllRequestMethodHandlers("DELETE").put(url, httpRequestHandler);
    }

    public void head(String url, HttpRequestHandler httpRequestHandler) {
        this.getAllRequestMethodHandlers("HEAD").put(url, httpRequestHandler);
    }

    public HttpRequestMethodHandlers getAllRequestMethodHandlers(String method) {
        return this.requestHandlers.computeIfAbsent(method.toUpperCase(), m -> new HttpRequestMethodHandlers());
    }

    public static class RequestMethod {
        public static final String GET = "GET";
        public static final String POST = "POST";
        public static final String PUT = "PUT";
        public static final String DELETE = "DELETE";
        public static final String HEAD = "HEAD";
        public static final String OPTIONS = "OPTIONS";

        private RequestMethod() {
        }
    }
}

