/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard.server.http.url;

import cn.boboweike.carrot.dashboard.server.http.url.RequestUrl;
import cn.boboweike.carrot.dashboard.server.http.url.UrlParamPathPart;
import cn.boboweike.carrot.dashboard.server.http.url.UrlPathPart;
import cn.boboweike.carrot.dashboard.server.http.url.UrlStringPathPart;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MatchUrl {
    private final String url;
    private final List<UrlPathPart> pathParts;

    public MatchUrl(String url) {
        this.url = url;
        String path = url;
        if (path.indexOf(63) > -1) {
            path = path.substring(0, path.indexOf(63));
        }
        this.pathParts = Stream.of(path.split("/")).map(this::toUrlPathPart).collect(Collectors.toList());
    }

    public String getUrl() {
        return this.url;
    }

    private UrlPathPart toUrlPathPart(String part) {
        if (part.startsWith(":")) {
            return new UrlParamPathPart(part);
        }
        return new UrlStringPathPart(part);
    }

    public boolean matches(String matchUrl) {
        if (this.url.equals(matchUrl)) {
            return true;
        }
        Iterator<UrlPathPart> iter1 = new MatchUrl((String)matchUrl).pathParts.iterator();
        Iterator<UrlPathPart> iter2 = this.pathParts.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            if (iter1.next().matches(iter2.next())) continue;
            return false;
        }
        return !iter1.hasNext() && !iter2.hasNext();
    }

    public RequestUrl toRequestUrl(String matchUrl) {
        HashMap<String, String> params = new HashMap<String, String>();
        Iterator<UrlPathPart> iter1 = new MatchUrl((String)matchUrl).pathParts.iterator();
        Iterator<UrlPathPart> iter2 = this.pathParts.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            UrlPathPart matchUrlPathPart = iter1.next();
            UrlPathPart actualUrlPathPart = iter2.next();
            if (!(matchUrlPathPart instanceof UrlParamPathPart)) continue;
            params.put(matchUrlPathPart.part(), actualUrlPathPart.part());
        }
        return new RequestUrl(this.url, params);
    }
}

