/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard.server.sse;

import cn.boboweike.carrot.dashboard.server.AbstractHttpExchangeHandler;
import cn.boboweike.carrot.dashboard.server.sse.SseExchange;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public abstract class ServerSentEventHandler
extends AbstractHttpExchangeHandler {
    private final String contextPath;
    private final Set<SseExchange> sseExchanges;

    protected ServerSentEventHandler() {
        this("/sse");
    }

    protected ServerSentEventHandler(String contextPath) {
        this.contextPath = contextPath;
        this.sseExchanges = new HashSet<SseExchange>();
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        this.sseExchanges.removeIf(SseExchange::isClosed);
        if (this.sseExchanges.size() > 40) {
            httpExchange.sendResponseHeaders(417, 0L);
            return;
        }
        this.sseExchanges.add(this.createSseExchange(httpExchange));
    }

    protected abstract SseExchange createSseExchange(HttpExchange var1) throws IOException;

    @Override
    public void close() {
        this.sseExchanges.forEach(SseExchange::close);
    }
}

