/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard.sse;

import cn.boboweike.carrot.dashboard.sse.AbstractObjectSseExchange;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.listeners.TaskChangeListener;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskId;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;

public class TaskSseExchange
extends AbstractObjectSseExchange
implements TaskChangeListener {
    private final PartitionedStorageProvider storageProvider;
    private final TaskId taskId;

    public TaskSseExchange(HttpExchange httpExchange, PartitionedStorageProvider storageProvider, JsonMapper jsonMapper) throws IOException {
        super(httpExchange, jsonMapper);
        this.storageProvider = storageProvider;
        this.taskId = TaskSseExchange.getTaskId(httpExchange);
        storageProvider.addTaskStorageOnChangeListener(this);
    }

    @Override
    public TaskId getTaskId() {
        return this.taskId;
    }

    @Override
    public void onChange(Task task) {
        this.sendObject(task);
        if (task.hasState(StateName.SUCCEEDED) || task.hasState(StateName.FAILED) || task.hasState(StateName.DELETED)) {
            this.close();
        }
    }

    @Override
    public void close() {
        this.storageProvider.removeTaskStorageOnChangeListener(this);
        super.close();
    }

    private static TaskId getTaskId(HttpExchange httpExchange) {
        String url = httpExchange.getRequestURI().toString();
        return TaskId.parse(url.substring("/sse/tasks/".length()));
    }
}

