/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard.ui.model.problems;

import cn.boboweike.carrot.dashboard.ui.model.problems.CpuAllocationIrregularityProblemHandler;
import cn.boboweike.carrot.dashboard.ui.model.problems.ProblemHandler;
import cn.boboweike.carrot.dashboard.ui.model.problems.Problems;
import cn.boboweike.carrot.dashboard.ui.model.problems.ScheduledTasksNotFoundProblemHandler;
import cn.boboweike.carrot.dashboard.ui.model.problems.SevereCarrotExceptionProblemHandler;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import java.util.HashMap;
import java.util.Map;

public class ProblemsManager {
    private final PartitionedStorageProvider storageProvider;
    private final Problems problems;
    private final Map<String, ProblemHandler> problemHandlers;

    public ProblemsManager(PartitionedStorageProvider storageProvider) {
        this.storageProvider = storageProvider;
        this.problems = new Problems();
        this.problemHandlers = this.initProblemHandlers();
    }

    private Map<String, ProblemHandler> initProblemHandlers() {
        HashMap<String, ProblemHandler> result = new HashMap<String, ProblemHandler>();
        result.put("tasks-not-found", new ScheduledTasksNotFoundProblemHandler(this.problems, this.storageProvider));
        result.put("severe-carrot-exception", new SevereCarrotExceptionProblemHandler(this.problems, this.storageProvider));
        result.put("cpu-allocation-irregularity", new CpuAllocationIrregularityProblemHandler(this.problems, this.storageProvider));
        return result;
    }

    public Problems getProblems() {
        return this.problems;
    }

    public void dismissProblemOfType(String param) {
        if (!this.problemHandlers.containsKey(param)) {
            throw new IllegalArgumentException("Unknown problem of type '" + param + "'");
        }
        this.problemHandlers.get(param).dismiss();
    }
}

