/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard.ui.model.problems;

import cn.boboweike.carrot.dashboard.ui.model.problems.ProblemHandler;
import cn.boboweike.carrot.dashboard.ui.model.problems.Problems;
import cn.boboweike.carrot.dashboard.ui.model.problems.ScheduledTasksNotFoundProblem;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.TaskStats;
import cn.boboweike.carrot.storage.TaskStatsData;
import cn.boboweike.carrot.storage.listeners.TaskStatsChangeListener;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.utils.TaskUtils;
import java.util.Set;
import java.util.stream.Collectors;

public class ScheduledTasksNotFoundProblemHandler
implements TaskStatsChangeListener,
ProblemHandler {
    private final Problems problems;
    private final PartitionedStorageProvider storageProvider;
    private TaskStats taskStats;

    public ScheduledTasksNotFoundProblemHandler(Problems problems, PartitionedStorageProvider storageProvider) {
        this.problems = problems;
        this.storageProvider = storageProvider;
        this.storageProvider.addTaskStorageOnChangeListener(this);
    }

    @Override
    public void dismiss() {
        throw new IllegalStateException("Problem of type 'tasks-not-found' cannot be dismissed.");
    }

    @Override
    public void onChange(TaskStatsData taskStatsData) {
        if (this.taskStats == null || taskStatsData.getOverallTaskStats().getScheduled() < this.taskStats.getScheduled()) {
            this.initScheduledTaskNotFoundProblems();
            this.taskStats = taskStatsData.getOverallTaskStats();
        }
    }

    private void initScheduledTaskNotFoundProblems() {
        this.problems.removeProblemsOfType("tasks-not-found");
        Set<String> tasksThatCannotBeFoundAnymore = this.storageProvider.getDistinctTaskSignatures(StateName.SCHEDULED).stream().filter(taskSignature -> !TaskUtils.taskExists(taskSignature)).collect(Collectors.toSet());
        if (!tasksThatCannotBeFoundAnymore.isEmpty()) {
            this.storageProvider.addTaskStorageOnChangeListener(this);
            this.taskStats = this.storageProvider.getTaskStatsData().getOverallTaskStats();
            this.problems.addProblem(new ScheduledTasksNotFoundProblem(tasksThatCannotBeFoundAnymore));
        } else {
            this.storageProvider.removeTaskStorageOnChangeListener(this);
        }
    }
}

