/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard.ui.model.problems;

import cn.boboweike.carrot.SevereCarrotException;
import cn.boboweike.carrot.dashboard.ui.model.problems.ProblemHandler;
import cn.boboweike.carrot.dashboard.ui.model.problems.Problems;
import cn.boboweike.carrot.dashboard.ui.model.problems.SevereCarrotExceptionProblem;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.listeners.MetadataChangeListener;
import java.util.List;

public class SevereCarrotExceptionProblemHandler
implements MetadataChangeListener,
ProblemHandler {
    private final Problems problems;
    private final PartitionedStorageProvider storageProvider;
    private List<CarrotMetadata> severeCarrotExceptionAsMetadataList;

    public SevereCarrotExceptionProblemHandler(Problems problems, PartitionedStorageProvider storageProvider) {
        this.problems = problems;
        this.storageProvider = storageProvider;
        this.storageProvider.addTaskStorageOnChangeListener(this);
        this.onChange(storageProvider.getMetadata(SevereCarrotException.class.getSimpleName()));
    }

    @Override
    public void dismiss() {
        this.problems.removeProblemsOfType("severe-carrot-exception");
        this.storageProvider.deleteMetadata(SevereCarrotException.class.getSimpleName());
    }

    @Override
    public String listenForChangesOfMetadataName() {
        return SevereCarrotException.class.getSimpleName();
    }

    @Override
    public void onChange(List<CarrotMetadata> metadataList) {
        if (this.severeCarrotExceptionAsMetadataList == null || this.severeCarrotExceptionAsMetadataList.size() != metadataList.size()) {
            this.problems.removeProblemsOfType("severe-carrot-exception");
            if (!metadataList.isEmpty()) {
                this.problems.addProblem(new SevereCarrotExceptionProblem(metadataList));
            }
            this.severeCarrotExceptionAsMetadataList = metadataList;
        }
    }
}

