/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.lock.inmemory;

import cn.boboweike.carrot.lock.LockProvider;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryLockProvider
implements LockProvider {
    private final Map<String, LockRecord> locks = new HashMap<String, LockRecord>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(String lockName, int durationInSeconds, String lockedBy) {
        Map<String, LockRecord> map = this.locks;
        synchronized (map) {
            Instant now = Instant.now();
            if (this.isLocked(lockName, now)) {
                return false;
            }
            LockRecord lockRecord = new LockRecord(now.plusSeconds(durationInSeconds));
            this.locks.put(lockName, lockRecord);
            this.logger.debug("Locked {} with duration {}", (Object)lockName, (Object)durationInSeconds);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLocked(String lockName, Instant now) {
        Map<String, LockRecord> map = this.locks;
        synchronized (map) {
            LockRecord lockRecord = this.locks.get(lockName);
            return lockRecord != null && lockRecord.lockedUntil.isAfter(now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean extend(String lockName, int durationInSeconds, String lockedBy) {
        Map<String, LockRecord> map = this.locks;
        synchronized (map) {
            Instant now = Instant.now();
            if (this.isLocked(lockName, now)) {
                this.locks.put(lockName, new LockRecord(now.plusSeconds(durationInSeconds)));
                this.logger.debug("Extended {} with duration {}", (Object)lockName, (Object)durationInSeconds);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unlock(String lockName) {
        Map<String, LockRecord> map = this.locks;
        synchronized (map) {
            Instant now = Instant.now();
            this.locks.put(lockName, new LockRecord(now));
        }
        return true;
    }

    private static class LockRecord {
        private final Instant lockedUntil;

        private LockRecord(Instant lockedUntil) {
            this.lockedUntil = lockedUntil;
        }
    }
}

