/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.lock.nosql;

import cn.boboweike.carrot.lock.LockProvider;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.Updates;
import java.time.Instant;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoLockProvider
implements LockProvider {
    static final String ID = "_id";
    private final MongoCollection<Document> collection;

    public MongoLockProvider(MongoCollection<Document> collection) {
        this.collection = collection;
    }

    @Override
    public boolean lock(String name, int durationInSeconds, String lockedBy) {
        Instant now = Instant.now();
        Bson update = Updates.combine((Bson[])new Bson[]{Updates.set((String)"lockUntil", (Object)now.plusSeconds(durationInSeconds)), Updates.set((String)"lockedAt", (Object)now), Updates.set((String)"lockedBy", (Object)lockedBy)});
        try {
            this.collection.findOneAndUpdate(Filters.and((Bson[])new Bson[]{Filters.eq((String)ID, (Object)name), Filters.lte((String)"lockUntil", (Object)now)}), update, new FindOneAndUpdateOptions().upsert(true));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean extend(String name, int durationInSeconds, String lockedBy) {
        Instant now = Instant.now();
        Bson update = Updates.set((String)"lockUntil", (Object)now.plusSeconds(durationInSeconds));
        try {
            Document updatedDocument = (Document)this.collection.findOneAndUpdate(Filters.and((Bson[])new Bson[]{Filters.eq((String)ID, (Object)name), Filters.gt((String)"lockUntil", (Object)now), Filters.eq((String)"lockedBy", (Object)lockedBy)}), update);
            return updatedDocument != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public boolean unlock(String name) {
        try {
            this.collection.findOneAndUpdate(Filters.eq((String)ID, (Object)name), Updates.combine((Bson[])new Bson[]{Updates.set((String)"lockUntil", (Object)Instant.now())}));
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

