/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.scheduling;

import cn.boboweike.carrot.configuration.Carrot;
import cn.boboweike.carrot.scheduling.Schedule;
import cn.boboweike.carrot.storage.ConcurrentTaskModificationException;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.RecurringTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.TaskId;
import cn.boboweike.carrot.tasks.filters.TaskDefaultFilters;
import cn.boboweike.carrot.tasks.filters.TaskFilter;
import cn.boboweike.carrot.tasks.filters.TaskFilterUtils;
import cn.boboweike.carrot.tasks.mappers.MDCMapper;
import cn.boboweike.carrot.tasks.states.ScheduledState;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractTaskScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTaskScheduler.class);
    private final PartitionedStorageProvider storageProvider;
    private final TaskFilterUtils taskFilterUtils;

    public AbstractTaskScheduler(PartitionedStorageProvider storageProvider) {
        this(storageProvider, Collections.emptyList());
    }

    public AbstractTaskScheduler(PartitionedStorageProvider storageProvider, List<TaskFilter> taskFilters) {
        if (storageProvider == null) {
            throw new IllegalArgumentException("A TaskStorageProvider is required to use the TaskScheduler. Please see the documentation on how to setup a TaskStorageProvider.");
        }
        this.storageProvider = storageProvider;
        this.taskFilterUtils = new TaskFilterUtils(new TaskDefaultFilters(taskFilters));
    }

    public void delete(TaskId taskId) {
        this.delete(taskId.asUUID());
    }

    public void delete(TaskId taskId, String reason) {
        this.delete(taskId.asUUID(), reason);
    }

    public void delete(UUID id) {
        this.delete(id, "Deleted via TaskScheduler API");
    }

    public void delete(UUID id, String reason) {
        Task taskToDelete = this.storageProvider.getTaskById(id);
        Task task = this.storageProvider.getTaskById(id);
        taskToDelete.delete(reason);
        this.taskFilterUtils.runOnStateElectionFilter(taskToDelete);
        Task deletedTask = this.storageProvider.save(taskToDelete);
        this.taskFilterUtils.runOnStateAppliedFilters(deletedTask);
        LOGGER.debug("Deleted Task with id {}", (Object)deletedTask.getId());
    }

    public void delete(String id) {
        this.storageProvider.deleteRecurringTask(id);
    }

    public void shutdown() {
        Carrot.destroy();
    }

    TaskId enqueue(UUID id, TaskDetails taskDetails) {
        return this.saveTask(new Task(id, taskDetails));
    }

    TaskId schedule(UUID id, Instant scheduleAt, TaskDetails taskDetails) {
        return this.saveTask(new Task(id, taskDetails, new ScheduledState(scheduleAt)));
    }

    String scheduleRecurrently(String id, TaskDetails taskDetails, Schedule schedule, ZoneId zoneId) {
        RecurringTask recurringTask = new RecurringTask(id, taskDetails, schedule, zoneId);
        this.taskFilterUtils.runOnCreatingFilter(recurringTask);
        RecurringTask savedRecurringTask = this.storageProvider.saveRecurringTask(recurringTask);
        this.taskFilterUtils.runOnCreatedFilter(recurringTask);
        return savedRecurringTask.getId();
    }

    TaskId saveTask(Task task) {
        try {
            MDCMapper.saveMDCContextToTask(task);
            this.taskFilterUtils.runOnCreatingFilter(task);
            Task savedTask = this.storageProvider.save(task);
            this.taskFilterUtils.runOnCreatedFilter(savedTask);
            LOGGER.debug("Created Task with id {}", (Object)task.getId());
        }
        catch (ConcurrentTaskModificationException e) {
            LOGGER.info("Skipped Task with id {} as it already exists", (Object)task.getId());
        }
        return new TaskId(task.getId());
    }

    List<Task> saveTasks(List<Task> tasks) {
        tasks.forEach(MDCMapper::saveMDCContextToTask);
        this.taskFilterUtils.runOnCreatingFilter(tasks);
        List<Task> savedTasks = this.storageProvider.save(tasks);
        this.taskFilterUtils.runOnCreatedFilter(savedTasks);
        return savedTasks;
    }
}

