/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.scheduling;

import cn.boboweike.carrot.scheduling.TaskScheduler;
import cn.boboweike.carrot.tasks.TaskId;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambda;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambdaFromStream;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import cn.boboweike.carrot.tasks.lambdas.TaskLambdaFromStream;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.UUID;
import java.util.stream.Stream;

public class BackgroundTask {
    private static TaskScheduler taskScheduler;

    BackgroundTask() {
    }

    public static TaskId enqueue(TaskLambda task) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.enqueue(task);
    }

    public static TaskId enqueue(UUID id, TaskLambda task) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.enqueue(id, task);
    }

    public static <T> void enqueue(Stream<T> input, TaskLambdaFromStream<T> taskFromStream) {
        BackgroundTask.verifyTaskScheduler();
        taskScheduler.enqueue(input, taskFromStream);
    }

    public static <S> TaskId enqueue(IocTaskLambda<S> iocTask) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.enqueue(iocTask);
    }

    public static <S> TaskId enqueue(UUID id, IocTaskLambda<S> iocTask) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.enqueue(id, iocTask);
    }

    public static <S, T> void enqueue(Stream<T> input, IocTaskLambdaFromStream<S, T> iocTaskFromStream) {
        BackgroundTask.verifyTaskScheduler();
        taskScheduler.enqueue(input, iocTaskFromStream);
    }

    public static TaskId schedule(ZonedDateTime zonedDateTime, TaskLambda task) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.schedule(zonedDateTime, task);
    }

    public static TaskId schedule(UUID id, ZonedDateTime zonedDateTime, TaskLambda task) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.schedule(id, zonedDateTime, task);
    }

    public static <S> TaskId schedule(ZonedDateTime zonedDateTime, IocTaskLambda<S> iocTask) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.schedule(zonedDateTime, iocTask);
    }

    public static <S> TaskId schedule(UUID id, ZonedDateTime zonedDateTime, IocTaskLambda<S> iocTask) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.schedule(id, zonedDateTime, iocTask);
    }

    public static TaskId schedule(OffsetDateTime offsetDateTime, TaskLambda task) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.schedule(offsetDateTime, task);
    }

    public static TaskId schedule(UUID id, OffsetDateTime offsetDateTime, TaskLambda task) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.schedule(id, offsetDateTime, task);
    }

    public static <S> TaskId schedule(OffsetDateTime offsetDateTime, IocTaskLambda<S> iocTask) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.schedule(offsetDateTime, iocTask);
    }

    public static <S> TaskId schedule(UUID id, OffsetDateTime offsetDateTime, IocTaskLambda<S> iocTask) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.schedule(id, offsetDateTime, iocTask);
    }

    public static TaskId schedule(LocalDateTime localDateTime, TaskLambda task) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.schedule(localDateTime, task);
    }

    public static TaskId schedule(UUID id, LocalDateTime localDateTime, TaskLambda task) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.schedule(id, localDateTime, task);
    }

    public static <S> TaskId schedule(LocalDateTime localDateTime, IocTaskLambda<S> iocTask) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.schedule(localDateTime, iocTask);
    }

    public static <S> TaskId schedule(UUID id, LocalDateTime localDateTime, IocTaskLambda<S> iocTask) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.schedule(id, localDateTime, iocTask);
    }

    public static TaskId schedule(Instant instant, TaskLambda task) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.schedule(instant, task);
    }

    public static TaskId schedule(UUID id, Instant instant, TaskLambda task) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.schedule(id, instant, task);
    }

    public static <S> TaskId schedule(Instant instant, IocTaskLambda<S> iocTask) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.schedule(instant, iocTask);
    }

    public static <S> TaskId schedule(UUID id, Instant instant, IocTaskLambda<S> iocTask) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.schedule(id, instant, iocTask);
    }

    public static void delete(UUID id) {
        BackgroundTask.verifyTaskScheduler();
        taskScheduler.delete(id);
    }

    public static void delete(TaskId taskId) {
        BackgroundTask.delete(taskId.asUUID());
    }

    public static String scheduleRecurrently(String cron, TaskLambda task) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.scheduleRecurrently(cron, task);
    }

    public static <S> String scheduleRecurrently(String cron, IocTaskLambda<S> iocTask) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.scheduleRecurrently(cron, iocTask);
    }

    public static String scheduleRecurrently(String id, String cron, TaskLambda task) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.scheduleRecurrently(id, cron, task);
    }

    public static <S> String scheduleRecurrently(String id, String cron, IocTaskLambda<S> iocTask) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.scheduleRecurrently(id, cron, iocTask);
    }

    public static String scheduleRecurrently(String id, String cron, ZoneId zoneId, TaskLambda task) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.scheduleRecurrently(id, cron, zoneId, task);
    }

    public static <S> String scheduleRecurrently(String id, String cron, ZoneId zoneId, IocTaskLambda<S> iocTask) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.scheduleRecurrently(id, cron, zoneId, iocTask);
    }

    public static String scheduleRecurrently(Duration duration, TaskLambda task) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.scheduleRecurrently(duration, task);
    }

    public static <S> String scheduleRecurrently(Duration duration, IocTaskLambda<S> iocTask) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.scheduleRecurrently(duration, iocTask);
    }

    public static String scheduleRecurrently(String id, Duration duration, TaskLambda task) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.scheduleRecurrently(id, duration, task);
    }

    public static <S> String scheduleRecurrently(String id, Duration duration, IocTaskLambda<S> iocTask) {
        BackgroundTask.verifyTaskScheduler();
        return taskScheduler.scheduleRecurrently(id, duration, iocTask);
    }

    public static void delete(String id) {
        BackgroundTask.verifyTaskScheduler();
        taskScheduler.delete(id);
    }

    private static void verifyTaskScheduler() {
        if (taskScheduler != null) {
            return;
        }
        throw new IllegalStateException("The TaskScheduler has not been initialized. Use the fluent Carrot.configure() API to setup Carrot or set the TaskScheduler via the static setter method.");
    }

    public static void setTaskScheduler(TaskScheduler taskScheduler) {
        BackgroundTask.taskScheduler = taskScheduler;
    }
}

