/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.scheduling;

import cn.boboweike.carrot.scheduling.TaskRequestScheduler;
import cn.boboweike.carrot.tasks.TaskId;
import cn.boboweike.carrot.tasks.lambdas.TaskRequest;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.UUID;
import java.util.stream.Stream;

public class BackgroundTaskRequest {
    private static TaskRequestScheduler taskRequestScheduler;

    private BackgroundTaskRequest() {
    }

    public static TaskId enqueue(TaskRequest taskRequest) {
        BackgroundTaskRequest.verifyTaskScheduler();
        return taskRequestScheduler.enqueue(taskRequest);
    }

    public static TaskId enqueue(UUID id, TaskRequest taskRequest) {
        BackgroundTaskRequest.verifyTaskScheduler();
        return taskRequestScheduler.enqueue(id, taskRequest);
    }

    public static void enqueue(Stream<? extends TaskRequest> input) {
        BackgroundTaskRequest.verifyTaskScheduler();
        taskRequestScheduler.enqueue(input);
    }

    public static TaskId schedule(ZonedDateTime zonedDateTime, TaskRequest taskRequest) {
        BackgroundTaskRequest.verifyTaskScheduler();
        return taskRequestScheduler.schedule(zonedDateTime.toInstant(), taskRequest);
    }

    public static TaskId schedule(UUID id, ZonedDateTime zonedDateTime, TaskRequest taskRequest) {
        BackgroundTaskRequest.verifyTaskScheduler();
        return taskRequestScheduler.schedule(id, zonedDateTime.toInstant(), taskRequest);
    }

    public static TaskId schedule(OffsetDateTime offsetDateTime, TaskRequest taskRequest) {
        BackgroundTaskRequest.verifyTaskScheduler();
        return taskRequestScheduler.schedule(offsetDateTime.toInstant(), taskRequest);
    }

    public static TaskId schedule(UUID id, OffsetDateTime offsetDateTime, TaskRequest taskRequest) {
        BackgroundTaskRequest.verifyTaskScheduler();
        return taskRequestScheduler.schedule(id, offsetDateTime.toInstant(), taskRequest);
    }

    public static TaskId schedule(LocalDateTime localDateTime, TaskRequest taskRequest) {
        BackgroundTaskRequest.verifyTaskScheduler();
        return taskRequestScheduler.schedule(localDateTime.atZone(ZoneId.systemDefault()).toInstant(), taskRequest);
    }

    public static TaskId schedule(UUID id, LocalDateTime localDateTime, TaskRequest taskRequest) {
        BackgroundTaskRequest.verifyTaskScheduler();
        return taskRequestScheduler.schedule(id, localDateTime.atZone(ZoneId.systemDefault()).toInstant(), taskRequest);
    }

    public static TaskId schedule(Instant instant, TaskRequest taskRequest) {
        BackgroundTaskRequest.verifyTaskScheduler();
        return taskRequestScheduler.schedule(instant, taskRequest);
    }

    public static TaskId schedule(UUID id, Instant instant, TaskRequest taskRequest) {
        BackgroundTaskRequest.verifyTaskScheduler();
        return taskRequestScheduler.schedule(id, instant, taskRequest);
    }

    public static void delete(UUID id) {
        BackgroundTaskRequest.verifyTaskScheduler();
        taskRequestScheduler.delete(id);
    }

    public static void delete(TaskId taskId) {
        BackgroundTaskRequest.delete(taskId.asUUID());
    }

    public static String scheduleRecurrently(String cron, TaskRequest taskRequest) {
        BackgroundTaskRequest.verifyTaskScheduler();
        return taskRequestScheduler.scheduleRecurrently(cron, taskRequest);
    }

    public static String scheduleRecurrently(String id, String cron, TaskRequest taskRequest) {
        BackgroundTaskRequest.verifyTaskScheduler();
        return taskRequestScheduler.scheduleRecurrently(id, cron, ZoneId.systemDefault(), taskRequest);
    }

    public static String scheduleRecurrently(String id, String cron, ZoneId zoneId, TaskRequest taskRequest) {
        BackgroundTaskRequest.verifyTaskScheduler();
        return taskRequestScheduler.scheduleRecurrently(id, cron, zoneId, taskRequest);
    }

    public static String scheduleRecurrently(Duration duration, TaskRequest taskRequest) {
        BackgroundTaskRequest.verifyTaskScheduler();
        return taskRequestScheduler.scheduleRecurrently(duration, taskRequest);
    }

    public static String scheduleRecurrently(String id, Duration duration, TaskRequest taskRequest) {
        BackgroundTaskRequest.verifyTaskScheduler();
        return taskRequestScheduler.scheduleRecurrently(id, duration, taskRequest);
    }

    public static void delete(String id) {
        BackgroundTaskRequest.verifyTaskScheduler();
        taskRequestScheduler.delete(id);
    }

    private static void verifyTaskScheduler() {
        if (taskRequestScheduler != null) {
            return;
        }
        throw new IllegalStateException("The TaskRequestScheduler has not been initialized. Use the fluent Carrot.configure() API to setup Carrot or set the TaskRequestScheduler via the static setter method.");
    }

    public static void setTaskRequestScheduler(TaskRequestScheduler taskRequestScheduler) {
        BackgroundTaskRequest.taskRequestScheduler = taskRequestScheduler;
    }
}

