/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.scheduling;

import cn.boboweike.carrot.utils.annotations.VisibleFor;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;

public abstract class Schedule
implements Comparable<Schedule> {
    public static final int SMALLEST_SCHEDULE_IN_SECONDS = 5;

    public Instant next(Instant createdAt, ZoneId zoneId) {
        return this.next(createdAt, Instant.now(), zoneId);
    }

    @VisibleFor(value="testing")
    public abstract Instant next(Instant var1, Instant var2, ZoneId var3);

    public abstract void validateSchedule();

    @Override
    public int compareTo(Schedule schedule) {
        if (schedule == this) {
            return 0;
        }
        Instant baseInstant = Instant.now();
        Instant nextAnother = schedule.next(baseInstant, ZoneOffset.UTC);
        Instant nextThis = this.next(baseInstant, ZoneOffset.UTC);
        return nextThis.compareTo(nextAnother);
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

