/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.scheduling;

import cn.boboweike.carrot.scheduling.AbstractTaskScheduler;
import cn.boboweike.carrot.scheduling.BackgroundTaskRequest;
import cn.boboweike.carrot.scheduling.cron.CronExpression;
import cn.boboweike.carrot.scheduling.interval.Interval;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.TaskId;
import cn.boboweike.carrot.tasks.filters.TaskFilter;
import cn.boboweike.carrot.tasks.lambdas.TaskRequest;
import cn.boboweike.carrot.utils.streams.StreamUtils;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;

public class TaskRequestScheduler
extends AbstractTaskScheduler {
    public TaskRequestScheduler(PartitionedStorageProvider storageProvider) {
        super(storageProvider, Collections.emptyList());
    }

    public TaskRequestScheduler(PartitionedStorageProvider storageProvider, List<TaskFilter> taskFilters) {
        super(storageProvider, taskFilters);
        BackgroundTaskRequest.setTaskRequestScheduler(this);
    }

    public TaskId enqueue(TaskRequest taskRequest) {
        return this.enqueue(null, taskRequest);
    }

    public TaskId enqueue(UUID id, TaskRequest taskRequest) {
        TaskDetails taskDetails = new TaskDetails(taskRequest);
        return this.enqueue(id, taskDetails);
    }

    public void enqueue(Stream<? extends TaskRequest> input) {
        input.map(TaskDetails::new).map(Task::new).collect(StreamUtils.batchCollector(5000, this::saveTasks));
    }

    public TaskId schedule(ZonedDateTime zonedDateTime, TaskRequest taskRequest) {
        return this.schedule(null, zonedDateTime.toInstant(), taskRequest);
    }

    public TaskId schedule(UUID id, ZonedDateTime zonedDateTime, TaskRequest taskRequest) {
        return this.schedule(id, zonedDateTime.toInstant(), taskRequest);
    }

    public TaskId schedule(OffsetDateTime offsetDateTime, TaskRequest taskRequest) {
        return this.schedule(null, offsetDateTime.toInstant(), taskRequest);
    }

    public TaskId schedule(UUID id, OffsetDateTime offsetDateTime, TaskRequest taskRequest) {
        return this.schedule(id, offsetDateTime.toInstant(), taskRequest);
    }

    public TaskId schedule(LocalDateTime localDateTime, TaskRequest taskRequest) {
        return this.schedule(localDateTime.atZone(ZoneId.systemDefault()).toInstant(), taskRequest);
    }

    public TaskId schedule(UUID id, LocalDateTime localDateTime, TaskRequest taskRequest) {
        return this.schedule(id, localDateTime.atZone(ZoneId.systemDefault()).toInstant(), taskRequest);
    }

    public TaskId schedule(Instant instant, TaskRequest taskRequest) {
        return this.schedule(null, instant, taskRequest);
    }

    public TaskId schedule(UUID id, Instant instant, TaskRequest taskRequest) {
        TaskDetails taskDetails = new TaskDetails(taskRequest);
        return this.schedule(id, instant, taskDetails);
    }

    public String scheduleRecurrently(String cron, TaskRequest taskRequest) {
        return this.scheduleRecurrently(null, cron, taskRequest);
    }

    public String scheduleRecurrently(String id, String cron, TaskRequest taskRequest) {
        return this.scheduleRecurrently(id, cron, ZoneId.systemDefault(), taskRequest);
    }

    public String scheduleRecurrently(String id, String cron, ZoneId zoneId, TaskRequest taskRequest) {
        TaskDetails taskDetails = new TaskDetails(taskRequest);
        return this.scheduleRecurrently(id, taskDetails, CronExpression.create(cron), zoneId);
    }

    public String scheduleRecurrently(Duration duration, TaskRequest taskRequest) {
        return this.scheduleRecurrently(null, duration, taskRequest);
    }

    public String scheduleRecurrently(String id, Duration duration, TaskRequest taskRequest) {
        TaskDetails taskDetails = new TaskDetails(taskRequest);
        return this.scheduleRecurrently(id, taskDetails, new Interval(duration), ZoneId.systemDefault());
    }
}

