/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.scheduling;

import cn.boboweike.carrot.scheduling.AbstractTaskScheduler;
import cn.boboweike.carrot.scheduling.BackgroundTask;
import cn.boboweike.carrot.scheduling.cron.CronExpression;
import cn.boboweike.carrot.scheduling.interval.Interval;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.TaskId;
import cn.boboweike.carrot.tasks.details.TaskDetailsAsmGenerator;
import cn.boboweike.carrot.tasks.details.TaskDetailsGenerator;
import cn.boboweike.carrot.tasks.filters.TaskFilter;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambda;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambdaFromStream;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import cn.boboweike.carrot.tasks.lambdas.TaskLambdaFromStream;
import cn.boboweike.carrot.utils.streams.StreamUtils;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;

public class TaskScheduler
extends AbstractTaskScheduler {
    private final TaskDetailsGenerator taskDetailsGenerator;

    public TaskScheduler(PartitionedStorageProvider storageProvider) {
        this(storageProvider, Collections.emptyList());
    }

    public TaskScheduler(PartitionedStorageProvider storageProvider, List<TaskFilter> taskFilters) {
        this(storageProvider, new TaskDetailsAsmGenerator(), taskFilters);
    }

    public TaskScheduler(PartitionedStorageProvider storageProvider, TaskDetailsGenerator taskDetailsGenerator, List<TaskFilter> taskFilters) {
        super(storageProvider, taskFilters);
        if (taskDetailsGenerator == null) {
            throw new IllegalArgumentException("A TaskDetailsGenerator is required to use the TaskScheduler.");
        }
        this.taskDetailsGenerator = taskDetailsGenerator;
        BackgroundTask.setTaskScheduler(this);
    }

    public TaskId enqueue(TaskLambda task) {
        return this.enqueue(null, task);
    }

    public TaskId enqueue(UUID id, TaskLambda task) {
        TaskDetails taskDetails = this.taskDetailsGenerator.toTaskDetails(task);
        return this.enqueue(id, taskDetails);
    }

    public <T> void enqueue(Stream<T> input, TaskLambdaFromStream<T> taskFromStream) {
        input.map(x -> this.taskDetailsGenerator.toTaskDetails(x, taskFromStream)).map(Task::new).collect(StreamUtils.batchCollector(5000, this::saveTasks));
    }

    public <S> TaskId enqueue(IocTaskLambda<S> iocTask) {
        return this.enqueue(null, iocTask);
    }

    public <S> TaskId enqueue(UUID id, IocTaskLambda<S> iocTask) {
        TaskDetails taskDetails = this.taskDetailsGenerator.toTaskDetails(iocTask);
        return this.enqueue(id, taskDetails);
    }

    public <S, T> void enqueue(Stream<T> input, IocTaskLambdaFromStream<S, T> iocTaskFromStream) {
        input.map(x -> this.taskDetailsGenerator.toTaskDetails(x, iocTaskFromStream)).map(Task::new).collect(StreamUtils.batchCollector(5000, this::saveTasks));
    }

    public TaskId schedule(ZonedDateTime zonedDateTime, TaskLambda task) {
        return this.schedule(null, zonedDateTime.toInstant(), task);
    }

    public TaskId schedule(UUID id, ZonedDateTime zonedDateTime, TaskLambda task) {
        return this.schedule(id, zonedDateTime.toInstant(), task);
    }

    public <S> TaskId schedule(ZonedDateTime zonedDateTime, IocTaskLambda<S> iocTask) {
        return this.schedule(null, zonedDateTime.toInstant(), iocTask);
    }

    public <S> TaskId schedule(UUID id, ZonedDateTime zonedDateTime, IocTaskLambda<S> iocTask) {
        return this.schedule(id, zonedDateTime.toInstant(), iocTask);
    }

    public TaskId schedule(OffsetDateTime offsetDateTime, TaskLambda task) {
        return this.schedule(null, offsetDateTime.toInstant(), task);
    }

    public TaskId schedule(UUID id, OffsetDateTime offsetDateTime, TaskLambda task) {
        return this.schedule(id, offsetDateTime.toInstant(), task);
    }

    public <S> TaskId schedule(OffsetDateTime offsetDateTime, IocTaskLambda<S> iocTask) {
        return this.schedule(null, offsetDateTime.toInstant(), iocTask);
    }

    public <S> TaskId schedule(UUID id, OffsetDateTime offsetDateTime, IocTaskLambda<S> iocTask) {
        return this.schedule(id, offsetDateTime.toInstant(), iocTask);
    }

    public TaskId schedule(LocalDateTime localDateTime, TaskLambda task) {
        return this.schedule(localDateTime.atZone(ZoneId.systemDefault()).toInstant(), task);
    }

    public TaskId schedule(UUID id, LocalDateTime localDateTime, TaskLambda task) {
        return this.schedule(id, localDateTime.atZone(ZoneId.systemDefault()).toInstant(), task);
    }

    public <S> TaskId schedule(LocalDateTime localDateTime, IocTaskLambda<S> iocTask) {
        return this.schedule(localDateTime.atZone(ZoneId.systemDefault()).toInstant(), iocTask);
    }

    public <S> TaskId schedule(UUID id, LocalDateTime localDateTime, IocTaskLambda<S> iocTask) {
        return this.schedule(id, localDateTime.atZone(ZoneId.systemDefault()).toInstant(), iocTask);
    }

    public TaskId schedule(Instant instant, TaskLambda task) {
        return this.schedule(null, instant, task);
    }

    public TaskId schedule(UUID id, Instant instant, TaskLambda task) {
        TaskDetails taskDetails = this.taskDetailsGenerator.toTaskDetails(task);
        return this.schedule(id, instant, taskDetails);
    }

    public <S> TaskId schedule(Instant instant, IocTaskLambda<S> iocTask) {
        return this.schedule(null, instant, iocTask);
    }

    public <S> TaskId schedule(UUID id, Instant instant, IocTaskLambda<S> iocTask) {
        TaskDetails taskDetails = this.taskDetailsGenerator.toTaskDetails(iocTask);
        return this.schedule(id, instant, taskDetails);
    }

    public String scheduleRecurrently(String cron, TaskLambda task) {
        return this.scheduleRecurrently(null, cron, task);
    }

    public <S> String scheduleRecurrently(String cron, IocTaskLambda<S> iocTask) {
        return this.scheduleRecurrently(null, cron, iocTask);
    }

    public String scheduleRecurrently(String id, String cron, TaskLambda task) {
        return this.scheduleRecurrently(id, cron, ZoneId.systemDefault(), task);
    }

    public <S> String scheduleRecurrently(String id, String cron, IocTaskLambda<S> iocTask) {
        return this.scheduleRecurrently(id, cron, ZoneId.systemDefault(), iocTask);
    }

    public String scheduleRecurrently(String id, String cron, ZoneId zoneId, TaskLambda task) {
        TaskDetails taskDetails = this.taskDetailsGenerator.toTaskDetails(task);
        return this.scheduleRecurrently(id, taskDetails, CronExpression.create(cron), zoneId);
    }

    public <S> String scheduleRecurrently(String id, String cron, ZoneId zoneId, IocTaskLambda<S> iocTask) {
        TaskDetails taskDetails = this.taskDetailsGenerator.toTaskDetails(iocTask);
        return this.scheduleRecurrently(id, taskDetails, CronExpression.create(cron), zoneId);
    }

    public String scheduleRecurrently(Duration duration, TaskLambda task) {
        return this.scheduleRecurrently(null, duration, task);
    }

    public <S> String scheduleRecurrently(Duration duration, IocTaskLambda<S> iocTask) {
        return this.scheduleRecurrently(null, duration, iocTask);
    }

    public String scheduleRecurrently(String id, Duration duration, TaskLambda task) {
        TaskDetails taskDetails = this.taskDetailsGenerator.toTaskDetails(task);
        return this.scheduleRecurrently(id, taskDetails, new Interval(duration), ZoneId.systemDefault());
    }

    public <S> String scheduleRecurrently(String id, Duration duration, IocTaskLambda<S> iocTask) {
        TaskDetails taskDetails = this.taskDetailsGenerator.toTaskDetails(iocTask);
        return this.scheduleRecurrently(id, taskDetails, new Interval(duration), ZoneId.systemDefault());
    }
}

