/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.scheduling.cron;

import cn.boboweike.carrot.scheduling.cron.InvalidCronExpressionException;
import java.util.BitSet;

public enum CronFieldType {
    SECOND(60, 0, 59),
    MINUTE(60, 0, 59),
    HOUR(24, 0, 23),
    DAY(31, 1, 31),
    MONTH(12, 1, 12),
    DAY_OF_WEEK(7, 0, 6);

    private final int length;
    private final int minAllowedValue;
    private final int maxAllowedValue;

    private CronFieldType(int length, int minAllowedValue, int maxAllowedValue) {
        this.length = length;
        this.minAllowedValue = minAllowedValue;
        this.maxAllowedValue = maxAllowedValue;
    }

    public String getFieldName() {
        return this.name().toLowerCase();
    }

    public int getLength() {
        return this.length;
    }

    public int getMinAllowedValue() {
        return this.minAllowedValue;
    }

    public int getMaxAllowedValue() {
        return this.maxAllowedValue;
    }

    public BitSet parseAsterisk() {
        if (this == MONTH) {
            return this.fillBitSet(1, this.length + 1);
        }
        return this.fillBitSet(0, this.length);
    }

    public BitSet parseLastDayOfMonth() {
        if (this == DAY) {
            BitSet bitSet = this.fillBitSet(27, this.length);
            return bitSet;
        }
        throw new InvalidCronExpressionException("Last day of month is only allowed in day field");
    }

    public BitSet fillBitSetToIncl(int from, int toIncluded) {
        int fromIndex = from - this.minAllowedValue;
        int toIndex = toIncluded - this.minAllowedValue + 1;
        if (this == MONTH) {
            fromIndex = from;
            toIndex = toIncluded + 1;
        }
        return this.fillBitSet(fromIndex, toIndex);
    }

    public BitSet fillBitSet(int from, int toExcluded) {
        BitSet bitSet = new BitSet(toExcluded);
        bitSet.set(from, toExcluded);
        return bitSet;
    }

    public void setBitSet(BitSet bitSet, int number) {
        bitSet.set(this == MONTH ? number : number - this.minAllowedValue);
    }
}

