/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.scheduling.exceptions;

import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.TaskParameter;
import cn.boboweike.carrot.tasks.TaskParameterNotDeserializableException;
import java.util.stream.Stream;

public class TaskNotFoundException
extends RuntimeException {
    public TaskNotFoundException(TaskDetails taskDetails) {
        this(taskDetails.getClassName(), taskDetails.getMethodName(), (String[])taskDetails.getTaskParameters().stream().map(TaskNotFoundException::toTaskParameterClassName).toArray(String[]::new), taskDetails.getTaskParameters().stream().anyMatch(x -> x.getObject() instanceof TaskParameterNotDeserializableException));
    }

    public TaskNotFoundException(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        this(clazz.getName(), methodName, (String[])Stream.of(parameterTypes).map(Class::getName).toArray(String[]::new), false);
    }

    public TaskNotFoundException(String className, String methodName, String[] parameterTypes, boolean isTaskParameterNotDeserializableException) {
        this(className + "." + methodName + "(" + String.join((CharSequence)",", parameterTypes) + ")" + (isTaskParameterNotDeserializableException ? "\n\tcaused by: one of the TaskParameters is not deserializable anymore" : ""));
    }

    public TaskNotFoundException(String message) {
        super(message);
        this.setStackTrace(new StackTraceElement[0]);
    }

    private static String toTaskParameterClassName(TaskParameter taskParameter) {
        if (taskParameter.getObject() instanceof TaskParameterNotDeserializableException) {
            return ((TaskParameterNotDeserializableException)taskParameter.getObject()).getClassName();
        }
        return taskParameter.getClassName();
    }
}

