/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.server.BackgroundTaskPerformer;
import cn.boboweike.carrot.server.BackgroundTaskServerConfiguration;
import cn.boboweike.carrot.server.ServerZooKeeper;
import cn.boboweike.carrot.server.TaskActivator;
import cn.boboweike.carrot.server.TaskZooKeeper;
import cn.boboweike.carrot.server.dashboard.DashboardNotificationManager;
import cn.boboweike.carrot.server.jmx.BackgroundTaskServerMBean;
import cn.boboweike.carrot.server.jmx.TaskServerStats;
import cn.boboweike.carrot.server.runner.BackgroundStaticFieldTaskWithoutIocRunner;
import cn.boboweike.carrot.server.runner.BackgroundStaticTaskWithoutIocRunner;
import cn.boboweike.carrot.server.runner.BackgroundTaskRunner;
import cn.boboweike.carrot.server.runner.BackgroundTaskWithIocRunner;
import cn.boboweike.carrot.server.runner.BackgroundTaskWithoutIocRunner;
import cn.boboweike.carrot.server.strategy.WorkDistributionStrategy;
import cn.boboweike.carrot.server.tasks.CheckIfAllTasksExistTask;
import cn.boboweike.carrot.server.tasks.CreateClusterIdIfNotExists;
import cn.boboweike.carrot.server.threadpool.CarrotExecutor;
import cn.boboweike.carrot.server.threadpool.ScheduledThreadPoolCarrotExecutor;
import cn.boboweike.carrot.storage.BackgroundTaskServerStatus;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.ThreadSafePartitionedStorageProvider;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.filters.TaskDefaultFilters;
import cn.boboweike.carrot.tasks.filters.TaskFilter;
import cn.boboweike.carrot.utils.TaskUtils;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundTaskServer
implements BackgroundTaskServerMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackgroundTaskServer.class);
    public static final Integer NO_PARTITION = -1;
    private final UUID backgroundTaskServerId;
    private final BackgroundTaskServerConfiguration configuration;
    private final PartitionedStorageProvider storageProvider;
    private final DashboardNotificationManager dashboardNotificationManager;
    private final List<BackgroundTaskRunner> backgroundTaskRunners;
    private final TaskDefaultFilters taskDefaultFilters;
    private final TaskServerStats taskServerStats;
    private final WorkDistributionStrategy workDistributionStrategy;
    private final ServerZooKeeper serverZooKeeper;
    private final TaskZooKeeper taskZooKeeper;
    private final BackgroundTaskServerLifecycleLock lifecycleLock;
    private volatile Instant firstHeartbeat;
    private volatile boolean isRunning;
    private volatile boolean isStopping;
    private volatile Integer partition;
    private volatile ScheduledThreadPoolExecutor zookeeperThreadPool;
    private CarrotExecutor taskExecutor;

    public BackgroundTaskServer(PartitionedStorageProvider storageProvider) {
        this(storageProvider, null);
    }

    public BackgroundTaskServer(PartitionedStorageProvider storageProvider, TaskActivator taskActivator) {
        this(storageProvider, taskActivator, BackgroundTaskServerConfiguration.usingStandardBackgroundTaskServerConfiguration());
    }

    public BackgroundTaskServer(PartitionedStorageProvider storageProvider, TaskActivator taskActivator, BackgroundTaskServerConfiguration configuration) {
        if (storageProvider == null) {
            throw new IllegalArgumentException("A StorageProvider is required to use a BackgroundTaskServer. Please see the documentation on how to setup a task StorageProvider.");
        }
        this.backgroundTaskServerId = UUID.randomUUID();
        this.configuration = configuration;
        this.storageProvider = new ThreadSafePartitionedStorageProvider(storageProvider);
        this.dashboardNotificationManager = new DashboardNotificationManager(this.backgroundTaskServerId, storageProvider);
        this.backgroundTaskRunners = this.initializeBackgroundTaskRunners(taskActivator);
        this.taskDefaultFilters = new TaskDefaultFilters(new TaskFilter[0]);
        this.taskServerStats = new TaskServerStats();
        this.workDistributionStrategy = this.createWorkDistributionStrategy(configuration);
        this.serverZooKeeper = this.createServerZooKeeper();
        this.taskZooKeeper = this.createTaskZooKeeper();
        this.lifecycleLock = new BackgroundTaskServerLifecycleLock();
    }

    @Override
    public UUID getId() {
        return this.backgroundTaskServerId;
    }

    @Override
    public void start() {
        this.start(true);
    }

    public void start(boolean guard) {
        if (guard) {
            if (this.isStarted()) {
                return;
            }
            try (BackgroundTaskServerLifecycleLock ignored = this.lifecycleLock.lock();){
                if (this.isStarted()) {
                    return;
                }
                this.firstHeartbeat = Instant.now();
                this.isRunning = true;
                this.isStopping = false;
                this.startZooKeepers();
                this.startWorkers();
                this.runStartupTasks();
            }
        }
    }

    @Override
    public void pauseProcessing() {
        if (this.isStopped()) {
            throw new IllegalStateException("First start the BackgroundTaskServer before pausing");
        }
        if (this.isPaused()) {
            return;
        }
        try (BackgroundTaskServerLifecycleLock ignored = this.lifecycleLock.lock();){
            this.isRunning = false;
            this.stopWorkers();
            LOGGER.info("Paused task processing");
        }
    }

    @Override
    public void resumeProcessing() {
        if (this.isStopped()) {
            throw new IllegalStateException("First start the BackgroundTaskServer before resuming");
        }
        if (this.isProcessing()) {
            return;
        }
        try (BackgroundTaskServerLifecycleLock ignored = this.lifecycleLock.lock();){
            this.startWorkers();
            this.isRunning = true;
            LOGGER.info("Resumed task processing");
        }
    }

    @Override
    public void stop() {
        if (this.isStopped()) {
            return;
        }
        try (BackgroundTaskServerLifecycleLock ignored = this.lifecycleLock.lock();){
            if (this.isStopped()) {
                return;
            }
            this.isStopping = true;
            LOGGER.info("BackgroundTaskServer and BackgroundTaskPerformers - stopping (waiting for all tasks to complete - max 10 seconds)");
            this.stopWorkers();
            this.stopZooKeepers();
            this.partition = null;
            this.isRunning = false;
            this.firstHeartbeat = null;
            LOGGER.info("BackgroundTaskServer and BackgroundTaskPerformers stopped");
            this.isStopping = false;
        }
    }

    public boolean isAnnounced() {
        return this.partition != null;
    }

    public boolean isUnAnnounced() {
        return !this.isAnnounced();
    }

    public Integer getPartition() {
        return this.partition;
    }

    void setPartition(Integer partition) {
        if (this.isStopped()) {
            return;
        }
        this.partition = partition;
        if (partition != null && partition != NO_PARTITION) {
            LOGGER.info("Carrot BackgroundTaskServer ({}) using {} and {} BackgroundTaskPerformers started successfully, acquired partition is {}.", new Object[]{this.getId(), this.storageProvider.getName(), this.workDistributionStrategy.getWorkerCount(), this.partition});
        } else {
            LOGGER.warn("Carrot BackgroundTaskServer failed to acquire partition");
        }
    }

    @Override
    public boolean isRunning() {
        try (BackgroundTaskServerLifecycleLock ignored = this.lifecycleLock.lock();){
            boolean bl = this.isRunning;
            return bl;
        }
    }

    @Override
    public BackgroundTaskServerStatus getServerStatus() {
        return new BackgroundTaskServerStatus(this.backgroundTaskServerId, this.workDistributionStrategy.getWorkerCount(), this.configuration.pollIntervalInSeconds, this.configuration.deleteSucceededTasksAfter, this.configuration.permanentlyDeleteDeletedTasksAfter, this.firstHeartbeat, Instant.now(), this.isRunning, this.taskServerStats.getSystemTotalMemory(), this.taskServerStats.getSystemFreeMemory(), this.taskServerStats.getSystemCpuLoad(), this.taskServerStats.getProcessMaxMemory(), this.taskServerStats.getProcessFreeMemory(), this.taskServerStats.getProcessAllocatedMemory(), this.taskServerStats.getProcessCpuLoad(), this.partition);
    }

    public TaskZooKeeper getTaskZooKeeper() {
        return this.taskZooKeeper;
    }

    public PartitionedStorageProvider getStorageProvider() {
        return this.storageProvider;
    }

    public BackgroundTaskServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public DashboardNotificationManager getDashboardNotificationManager() {
        return this.dashboardNotificationManager;
    }

    public WorkDistributionStrategy getWorkDistributionStrategy() {
        return this.workDistributionStrategy;
    }

    public void setTaskFilters(List<TaskFilter> taskFilters) {
        this.taskDefaultFilters.addAll(taskFilters);
    }

    public TaskDefaultFilters getTaskFilters() {
        return this.taskDefaultFilters;
    }

    BackgroundTaskRunner getBackgroundTaskRunner(Task task) {
        TaskUtils.assertTaskExists(task.getTaskDetails());
        return this.backgroundTaskRunners.stream().filter(taskRunner -> taskRunner.supports(task)).findFirst().orElseThrow(() -> CarrotException.problematicConfigurationException("Could not find a BackgroundTaskRunner: either no TaskActivator is registered, your Background Task Class is not registered within the IoC container or your Task does not have a default no-arg constructor."));
    }

    void processTask(Task task) {
        BackgroundTaskPerformer backgroundTaskPerformer = new BackgroundTaskPerformer(this, task);
        this.taskExecutor.execute(backgroundTaskPerformer);
        LOGGER.debug("Submitted BackgroundTaskPerformer for task {} to executor service", (Object)task.getId());
    }

    boolean isStarted() {
        return !this.isStopped();
    }

    boolean isStopped() {
        return this.zookeeperThreadPool == null;
    }

    public boolean isStoppingOrStopped() {
        return this.isStopping || this.zookeeperThreadPool == null;
    }

    boolean isPaused() {
        return !this.isProcessing();
    }

    boolean isProcessing() {
        try (BackgroundTaskServerLifecycleLock ignored = this.lifecycleLock.lock();){
            boolean bl = this.isRunning;
            return bl;
        }
    }

    private void startZooKeepers() {
        this.zookeeperThreadPool = new ScheduledThreadPoolCarrotExecutor(2, "backgroundtask-zookeeper-pool");
        this.zookeeperThreadPool.scheduleWithFixedDelay(this.serverZooKeeper, 0L, this.configuration.pollIntervalInSeconds, TimeUnit.SECONDS);
        this.zookeeperThreadPool.scheduleWithFixedDelay(this.taskZooKeeper, 1L, this.configuration.pollIntervalInSeconds, TimeUnit.SECONDS);
    }

    private void stopZooKeepers() {
        this.serverZooKeeper.stop();
        this.stop(this.zookeeperThreadPool);
        this.zookeeperThreadPool = null;
    }

    private void startWorkers() {
        this.taskExecutor = this.loadCarrotExecutor();
        this.taskExecutor.start();
    }

    private void stopWorkers() {
        if (this.taskExecutor == null) {
            return;
        }
        this.taskExecutor.stop();
        this.taskExecutor = null;
    }

    private void runStartupTasks() {
        try {
            List<Runnable> startupTasks = Arrays.asList(new CreateClusterIdIfNotExists(this), new CheckIfAllTasksExistTask(this));
            startupTasks.forEach(this.taskExecutor::execute);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<BackgroundTaskRunner> initializeBackgroundTaskRunners(TaskActivator taskActivator) {
        return Arrays.asList(new BackgroundTaskWithIocRunner(taskActivator), new BackgroundTaskWithoutIocRunner(), new BackgroundStaticTaskWithoutIocRunner(), new BackgroundStaticFieldTaskWithoutIocRunner());
    }

    private void stop(ScheduledExecutorService executorService) {
        if (executorService == null) {
            return;
        }
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOGGER.info("Carrot BackgroundTaskServer shutdown requested - waiting for tasks to finish (at most 10 seconds)");
                executorService.shutdownNow();
                if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException e) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private ServerZooKeeper createServerZooKeeper() {
        return new ServerZooKeeper(this);
    }

    private TaskZooKeeper createTaskZooKeeper() {
        return new TaskZooKeeper(this);
    }

    private WorkDistributionStrategy createWorkDistributionStrategy(BackgroundTaskServerConfiguration configuration) {
        return configuration.backgroundTaskServerWorkerPolicy.toWorkDistributionStrategy(this);
    }

    private CarrotExecutor loadCarrotExecutor() {
        ServiceLoader<CarrotExecutor> serviceLoader = ServiceLoader.load(CarrotExecutor.class);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(serviceLoader.iterator(), 16), false).sorted((a, b) -> Integer.compare(b.getPriority(), a.getPriority())).findFirst().orElse(new ScheduledThreadPoolCarrotExecutor(this.workDistributionStrategy.getWorkerCount(), "backgroundtask-worker-pool"));
    }

    private static class BackgroundTaskServerLifecycleLock
    implements AutoCloseable {
        private final ReentrantLock reentrantLock = new ReentrantLock();

        private BackgroundTaskServerLifecycleLock() {
        }

        public BackgroundTaskServerLifecycleLock lock() {
            if (this.reentrantLock.isHeldByCurrentThread()) {
                return this;
            }
            this.reentrantLock.lock();
            return this;
        }

        @Override
        public void close() {
            this.reentrantLock.unlock();
        }
    }
}

