/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server;

import cn.boboweike.carrot.server.configuration.BackgroundTaskServerWorkerPolicy;
import cn.boboweike.carrot.server.configuration.ConcurrentTaskModificationPolicy;
import cn.boboweike.carrot.server.configuration.DefaultBackgroundTaskServerWorkerPolicy;
import cn.boboweike.carrot.server.configuration.DefaultConcurrentTaskModificationPolicy;
import cn.boboweike.carrot.server.configuration.FixedSizeBackgroundTaskServerWorkerPolicy;
import java.time.Duration;

public class BackgroundTaskServerConfiguration {
    public static final int DEFAULT_POLL_INTERVAL_IN_SECONDS = 15;
    public static final Duration DEFAULT_DELETE_SUCCEEDED_TASKS_DURATION = Duration.ofHours(36L);
    public static final Duration DEFAULT_PERMANENTLY_DELETE_TASKS_DURATION = Duration.ofHours(72L);
    int pollIntervalInSeconds = 15;
    Duration deleteSucceededTasksAfter = DEFAULT_DELETE_SUCCEEDED_TASKS_DURATION;
    Duration permanentlyDeleteDeletedTasksAfter = DEFAULT_PERMANENTLY_DELETE_TASKS_DURATION;
    BackgroundTaskServerWorkerPolicy backgroundTaskServerWorkerPolicy = new DefaultBackgroundTaskServerWorkerPolicy();
    ConcurrentTaskModificationPolicy concurrentTaskModificationPolicy = new DefaultConcurrentTaskModificationPolicy();

    private BackgroundTaskServerConfiguration() {
    }

    public static BackgroundTaskServerConfiguration usingStandardBackgroundTaskServerConfiguration() {
        return new BackgroundTaskServerConfiguration();
    }

    public BackgroundTaskServerConfiguration andPollIntervalInSeconds(int pollIntervalInSeconds) {
        if (pollIntervalInSeconds < 5) {
            throw new IllegalArgumentException("The pollIntervalInSeconds can not be smaller than 5 - otherwise it will cause too much load on your SQL/noSQL datastore.");
        }
        this.pollIntervalInSeconds = pollIntervalInSeconds;
        return this;
    }

    public BackgroundTaskServerConfiguration andWorkerCount(int workerCount) {
        this.backgroundTaskServerWorkerPolicy = new FixedSizeBackgroundTaskServerWorkerPolicy(workerCount);
        return this;
    }

    public BackgroundTaskServerConfiguration andBackgroundTaskServerWorkerPolicy(BackgroundTaskServerWorkerPolicy backgroundTaskServerWorkerPolicy) {
        this.backgroundTaskServerWorkerPolicy = backgroundTaskServerWorkerPolicy;
        return this;
    }

    public BackgroundTaskServerConfiguration andDeleteSucceededTasksAfter(Duration duration) {
        this.deleteSucceededTasksAfter = duration;
        return this;
    }

    public BackgroundTaskServerConfiguration andPermanentlyDeleteDeletedTasksAfter(Duration duration) {
        this.permanentlyDeleteDeletedTasksAfter = duration;
        return this;
    }

    public BackgroundTaskServerConfiguration andConcurrentTaskModificationPolicy(ConcurrentTaskModificationPolicy concurrentTaskModificationPolicy) {
        this.concurrentTaskModificationPolicy = concurrentTaskModificationPolicy;
        return this;
    }
}

